/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.bolt.runtime.BoltConnectionFatality;

public class BytesAccumulator
extends ChannelInboundHandlerAdapter {
    private final long limit;
    private long count;

    public BytesAccumulator(long limit) {
        this.limit = limit;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        this.count += (long)buf.readableBytes();
        if (this.count < 0L) {
            this.count = Long.MAX_VALUE;
        }
        if (this.count > this.limit) {
            ctx.channel().close();
            throw new BoltConnectionFatality(String.format("A connection '%s' is terminated because too many inbound bytes received before the client is authenticated. Max bytes allowed: %s. Bytes received: %s.", ctx.channel(), this.limit, this.count), null);
        }
        super.channelRead(ctx, msg);
    }
}

