/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v41.messaging.decoder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.bolt.v41.messaging.request.HelloMessage;
import org.neo4j.kernel.api.exceptions.Status;

public class HelloMessageDecoder
extends org.neo4j.bolt.v3.messaging.decoder.HelloMessageDecoder {
    public HelloMessageDecoder(BoltResponseHandler responseHandler) {
        super(responseHandler);
    }

    @Override
    public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
        Map<String, Object> meta = HelloMessageDecoder.readMetaDataMap(unpacker);
        RoutingContext routingContext = this.parseRoutingContext(meta);
        return new HelloMessage(meta, routingContext);
    }

    private RoutingContext parseRoutingContext(Map<String, Object> meta) throws BoltIOException {
        Map routingObjectMap = meta.getOrDefault("routing", null);
        if (routingObjectMap == null) {
            return new RoutingContext(false, Collections.emptyMap());
        }
        HashMap<String, String> routingStringMap = new HashMap<String, String>();
        for (Map.Entry entry : routingObjectMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) {
                throw new BoltIOException((Status)Status.Request.Invalid, "Routing information in the HELLO message must be a map with string keys and string values.");
            }
            routingStringMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return new RoutingContext(true, routingStringMap);
    }
}

