/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime.bookmarking;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarkParsingException;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarkWithDatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class BookmarksParserV4
implements BookmarksParser {
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final long ABSENT_BOOKMARK_ID = -1L;
    private final DatabaseIdRepository databaseIdRepository;
    private final CustomBookmarkFormatParser customBookmarkFormatParser;

    public BookmarksParserV4(DatabaseIdRepository databaseIdRepository, CustomBookmarkFormatParser customBookmarkFormatParser) {
        this.databaseIdRepository = databaseIdRepository;
        this.customBookmarkFormatParser = customBookmarkFormatParser;
    }

    @Override
    public List<Bookmark> parseBookmarks(MapValue metadata) throws BoltIOException {
        AnyValue bookmarksObject = metadata.get(BOOKMARKS_KEY);
        if (bookmarksObject == Values.NO_VALUE) {
            return List.of();
        }
        if (bookmarksObject instanceof ListValue) {
            return this.parseBookmarks((ListValue)bookmarksObject);
        }
        throw BookmarkParsingException.newInvalidBookmarkError(String.format("Supplied bookmarks '%s' is not a List.", bookmarksObject));
    }

    private List<Bookmark> parseBookmarks(ListValue bookmarks) throws BookmarkParsingException {
        List<Bookmark> customBookmarks;
        long maxSystemDbTxId = -1L;
        NamedDatabaseId userDbId = null;
        long maxUserDbTxId = -1L;
        ArrayList<String> customBookmarkStrings = new ArrayList<String>();
        for (AnyValue bookmark : bookmarks) {
            if (bookmark == Values.NO_VALUE) continue;
            String bookmarkString = this.toBookmarkString(bookmark);
            if (this.customBookmarkFormatParser.isCustomBookmark(bookmarkString)) {
                customBookmarkStrings.add(bookmarkString);
                continue;
            }
            ParsedBookmark parsedBookmark = this.parse(bookmarkString);
            if (DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.equals((Object)parsedBookmark.namedDatabaseId)) {
                maxSystemDbTxId = Math.max(maxSystemDbTxId, parsedBookmark.txId);
                continue;
            }
            if (userDbId == null) {
                userDbId = parsedBookmark.namedDatabaseId;
            } else {
                BookmarksParserV4.assertSameDatabaseId(userDbId, parsedBookmark.namedDatabaseId, bookmarks);
            }
            maxUserDbTxId = Math.max(maxUserDbTxId, parsedBookmark.txId);
        }
        if (customBookmarkStrings.isEmpty()) {
            return BookmarksParserV4.buildBookmarks(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, maxSystemDbTxId, userDbId, maxUserDbTxId);
        }
        try {
            customBookmarks = this.customBookmarkFormatParser.parse(customBookmarkStrings);
        }
        catch (Exception e) {
            throw BookmarkParsingException.newInvalidBookmarkError("Parsing of supplied bookmarks failed with message: " + e.getMessage(), e);
        }
        if (maxSystemDbTxId != -1L) {
            customBookmarks.add(new BookmarkWithDatabaseId(maxSystemDbTxId, DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID));
        }
        if (maxUserDbTxId != -1L) {
            customBookmarks.add(new BookmarkWithDatabaseId(maxUserDbTxId, userDbId));
        }
        return customBookmarks;
    }

    private ParsedBookmark parse(String bookmarkString) throws BookmarkParsingException {
        String[] split = bookmarkString.split(":");
        if (split.length != 2) {
            throw BookmarkParsingException.newInvalidSingleBookmarkError(bookmarkString);
        }
        UUID databaseUuid = BookmarksParserV4.parseDatabaseId(split[0], bookmarkString);
        NamedDatabaseId databaseId = (NamedDatabaseId)this.databaseIdRepository.getById(DatabaseIdFactory.from((UUID)databaseUuid)).orElseThrow(() -> BookmarkParsingException.newInvalidBookmarkForUnknownDatabaseError(databaseUuid));
        long txId = BookmarksParserV4.parseTxId(split[1], bookmarkString);
        return new ParsedBookmark(databaseId, txId);
    }

    private String toBookmarkString(AnyValue bookmark) throws BookmarkParsingException {
        if (!(bookmark instanceof TextValue)) {
            throw BookmarkParsingException.newInvalidSingleBookmarkError(bookmark);
        }
        return ((TextValue)bookmark).stringValue();
    }

    private static UUID parseDatabaseId(String uuid, String bookmark) throws BookmarkParsingException {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw BookmarkParsingException.newInvalidSingleBookmarkError(bookmark, String.format("Unable to parse database id: %s", uuid), e);
        }
    }

    private static long parseTxId(String txIdString, String bookmark) throws BookmarkParsingException {
        try {
            return Long.parseLong(txIdString);
        }
        catch (NumberFormatException e) {
            throw BookmarkParsingException.newInvalidSingleBookmarkError(bookmark, String.format("Unable to parse transaction id: %s", txIdString), e);
        }
    }

    private static void assertSameDatabaseId(NamedDatabaseId id1, NamedDatabaseId id2, ListValue bookmarks) throws BookmarkParsingException {
        if (!id1.equals((Object)id2)) {
            throw BookmarkParsingException.newInvalidBookmarkMixtureError(bookmarks);
        }
    }

    private static List<Bookmark> buildBookmarks(NamedDatabaseId systemDbId, long maxSystemDbTxId, NamedDatabaseId userDbId, long maxUserDbTxId) {
        if (maxSystemDbTxId != -1L && maxUserDbTxId != -1L) {
            return List.of(new BookmarkWithDatabaseId(maxSystemDbTxId, systemDbId), new BookmarkWithDatabaseId(maxUserDbTxId, userDbId));
        }
        if (maxSystemDbTxId != -1L) {
            return List.of(new BookmarkWithDatabaseId(maxSystemDbTxId, systemDbId));
        }
        if (maxUserDbTxId != -1L) {
            return List.of(new BookmarkWithDatabaseId(maxUserDbTxId, userDbId));
        }
        return List.of();
    }

    private static class ParsedBookmark {
        final NamedDatabaseId namedDatabaseId;
        final long txId;

        ParsedBookmark(NamedDatabaseId namedDatabaseId, long txId) {
            this.namedDatabaseId = namedDatabaseId;
            this.txId = txId;
        }
    }
}

