/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ProtocolHandshaker
extends ChannelInboundHandlerAdapter {
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    private static final int HANDSHAKE_BUFFER_SIZE = 20;
    private final BoltChannel boltChannel;
    private final BoltProtocolFactory boltProtocolFactory;
    private final Log log;
    private final boolean encryptionRequired;
    private final boolean encrypted;
    private ByteBuf handshakeBuffer;
    private BoltProtocol protocol;

    public ProtocolHandshaker(BoltProtocolFactory boltProtocolFactory, BoltChannel boltChannel, LogProvider logging, boolean encryptionRequired, boolean encrypted) {
        this.boltProtocolFactory = boltProtocolFactory;
        this.boltChannel = boltChannel;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
        this.encryptionRequired = encryptionRequired;
        this.encrypted = encrypted;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeBuffer = ctx.alloc().buffer(20, 20);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.handshakeBuffer.release();
        this.handshakeBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (!(msg instanceof ByteBuf)) {
                this.log.warn("Unsupported connection type: 'HTTP'. Bolt protocol only operates over a TCP connection or WebSocket.");
                ctx.close();
                return;
            }
            ByteBuf buf = (ByteBuf)msg;
            this.assertEncryptedIfRequired();
            this.handshakeBuffer.writeBytes(buf, Math.min(buf.readableBytes(), this.handshakeBuffer.writableBytes()));
            if (this.handshakeBuffer.writableBytes() == 0) {
                if (this.verifyBoltPreamble()) {
                    if (this.performHandshake()) {
                        ctx.writeAndFlush((Object)ctx.alloc().buffer(4).writeInt(this.protocol.version().toInt()));
                        this.protocol.install();
                        ctx.pipeline().remove((ChannelHandler)this);
                        if (buf.readableBytes() > 0) {
                            ctx.fireChannelRead((Object)buf.readRetainedSlice(buf.readableBytes()));
                        }
                    } else {
                        ctx.writeAndFlush((Object)ctx.alloc().buffer().writeBytes(new byte[]{0, 0, 0, 0})).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error("Fatal error occurred during protocol handshaking: " + ctx.channel(), cause);
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.close();
    }

    private void assertEncryptedIfRequired() {
        if (this.encryptionRequired && !this.encrypted) {
            throw new SecurityException("An unencrypted connection attempt was made where encryption is required.");
        }
    }

    private boolean verifyBoltPreamble() {
        if (this.handshakeBuffer.getInt(0) != 1616949271) {
            this.log.debug("Invalid Bolt handshake signature. Expected 0x%08X, but got: 0x%08X", new Object[]{1616949271, this.handshakeBuffer.getInt(0)});
            return false;
        }
        return true;
    }

    private boolean performHandshake() {
        Object[] suggestions = new BoltProtocolVersion[4];
        for (int i = 0; i < 4; ++i) {
            BoltProtocolVersion suggestion = BoltProtocolVersion.fromRawBytes(this.handshakeBuffer.getInt((i + 1) * 4));
            this.protocol = this.boltProtocolFactory.create(suggestion, this.boltChannel);
            if (this.protocol != null) break;
            suggestions[i] = suggestion;
        }
        if (this.protocol == null) {
            this.log.debug("Failed Bolt handshake: Bolt versions suggested by client '%s' are not supported by this server.", new Object[]{Arrays.toString(suggestions)});
        }
        return this.protocol != null;
    }
}

