/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.messaging;

import java.util.Objects;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public abstract class AbstractStreamingMessage
implements RequestMessage {
    private static final String STREAM_LIMIT_KEY = "n";
    private static final long STREAM_LIMIT_MINIMAL = 1L;
    public static final long STREAM_LIMIT_UNLIMITED = -1L;
    private final MapValue meta;
    private final long n;
    private final int statementId;

    public AbstractStreamingMessage(MapValue meta) throws BoltIOException {
        this.meta = Objects.requireNonNull(meta);
        this.n = this.parseN(meta);
        this.statementId = this.parseStatementId(meta);
    }

    private long parseN(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(STREAM_LIMIT_KEY);
        if (anyValue != Values.NO_VALUE && anyValue instanceof LongValue) {
            long size = ((LongValue)anyValue).longValue();
            if (size != -1L && size < 1L) {
                throw new BoltIOException((Status)Status.Request.Invalid, String.format("Expecting %s size to be at least %s, but got: %s", this.name(), 1L, this.n));
            }
            return size;
        }
        throw new BoltIOException((Status)Status.Request.Invalid, String.format("Expecting %s size n to be a Long value, but got: %s", this.name(), anyValue));
    }

    private int parseStatementId(MapValue meta) {
        AnyValue anyValue = meta.get("qid");
        if (anyValue != Values.NO_VALUE && anyValue instanceof LongValue) {
            long id = ((LongValue)anyValue).longValue();
            return Math.toIntExact(id);
        }
        return -1;
    }

    public long n() {
        return this.n;
    }

    public int statementId() {
        return this.statementId;
    }

    public MapValue meta() {
        return this.meta;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStreamingMessage that = (AbstractStreamingMessage)o;
        return Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }

    public String toString() {
        return String.format("%s %s", this.name(), this.meta());
    }

    abstract String name();
}

