/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v3.messaging.decoder.PrimitiveOnlyValueWriter;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class HelloMessageDecoder
implements RequestMessageDecoder {
    private final BoltResponseHandler responseHandler;

    public HelloMessageDecoder(BoltResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    @Override
    public int signature() {
        return 1;
    }

    @Override
    public BoltResponseHandler responseHandler() {
        return this.responseHandler;
    }

    @Override
    public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
        Map<String, Object> meta = HelloMessageDecoder.readMetaDataMap(unpacker);
        HelloMessageDecoder.assertUserAgentPresent(meta);
        return new HelloMessage(meta);
    }

    private static Map<String, Object> readMetaDataMap(Neo4jPack.Unpacker unpacker) throws IOException {
        MapValue metaDataMapValue = unpacker.unpackMap();
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>(metaDataMapValue.size());
        metaDataMapValue.foreach((key, value) -> {
            Object convertedValue = AuthToken.containsSensitiveInformation((String)key) ? writer.sensitiveValueAsObject((AnyValue)value) : writer.valueAsObject((AnyValue)value);
            metaDataMap.put((String)key, convertedValue);
        });
        return metaDataMap;
    }

    private static void assertUserAgentPresent(Map<String, Object> metaData) throws BoltIOException {
        if (!metaData.containsKey("user_agent")) {
            throw new BoltIOException((Status)Status.Request.Invalid, "Expected \"user_agent\" in metadata");
        }
    }
}

