/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarksParserV3;
import org.neo4j.logging.internal.LogService;

public abstract class AbstractBoltProtocol
implements BoltProtocol {
    private final Neo4jPack neo4jPack;
    private final BoltConnection connection;
    private final BoltRequestMessageReader messageReader;
    private final BoltChannel channel;
    private final LogService logging;

    public AbstractBoltProtocol(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, LogService logging) {
        this(channel, connectionFactory, stateMachineFactory, BookmarksParserV3.INSTANCE, logging);
    }

    protected AbstractBoltProtocol(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, BookmarksParser bookmarksParser, LogService logging) {
        this.channel = channel;
        this.logging = logging;
        BoltStateMachine stateMachine = stateMachineFactory.newStateMachine(this.version(), channel);
        this.connection = connectionFactory.newConnection(channel, stateMachine);
        this.neo4jPack = this.createPack();
        this.messageReader = this.createMessageReader(channel, this.neo4jPack, this.connection, bookmarksParser, logging);
    }

    @Override
    public void install() {
        ChannelPipeline pipeline = this.channel.rawChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChunkDecoder()});
        pipeline.addLast(new ChannelHandler[]{new MessageAccumulator()});
        pipeline.addLast(new ChannelHandler[]{new MessageDecoder(this.neo4jPack, this.messageReader, this.logging)});
        pipeline.addLast(new ChannelHandler[]{new HouseKeeper(this.connection, this.logging.getInternalLog(HouseKeeper.class))});
    }

    protected abstract Neo4jPack createPack();

    protected abstract BoltRequestMessageReader createMessageReader(BoltChannel var1, Neo4jPack var2, BoltConnection var3, BookmarksParser var4, LogService var5);
}

