/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.kernel.impl.query.clientconnection.BoltConnectionInfo;

public class BoltChannel
implements TrackedNetworkConnection {
    private final String id;
    private final long connectTime;
    private final String connector;
    private final Channel rawChannel;
    private volatile String username;
    private volatile String userAgent;
    private volatile ClientConnectionInfo info;

    public BoltChannel(String id, String connector, Channel rawChannel) {
        this.id = id;
        this.connectTime = System.currentTimeMillis();
        this.connector = connector;
        this.rawChannel = rawChannel;
        this.info = this.createConnectionInfo();
    }

    public Channel rawChannel() {
        return this.rawChannel;
    }

    public ClientConnectionInfo info() {
        return this.info;
    }

    public String id() {
        return this.id;
    }

    public long connectTime() {
        return this.connectTime;
    }

    public String connector() {
        return this.connector;
    }

    public SocketAddress serverAddress() {
        return this.rawChannel.localAddress();
    }

    public SocketAddress clientAddress() {
        return this.rawChannel.remoteAddress();
    }

    public String username() {
        return this.username;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public void updateUser(String username, String userAgent) {
        this.username = username;
        this.userAgent = userAgent;
        this.info = this.createConnectionInfo();
    }

    public void close() {
        Channel rawChannel = this.rawChannel();
        if (rawChannel.isOpen()) {
            rawChannel.close().syncUninterruptibly();
        }
    }

    public String toString() {
        return "BoltChannel{id='" + this.id + "', connectTime=" + this.connectTime + ", connector='" + this.connector + "', rawChannel=" + this.rawChannel + ", username='" + this.username + "', userAgent='" + this.userAgent + "'}";
    }

    private ClientConnectionInfo createConnectionInfo() {
        return new BoltConnectionInfo(this.id, this.userAgent, this.clientAddress(), this.serverAddress());
    }
}

