/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.transport.TransportThrottleException;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.kernel.api.exceptions.Status;

public class ChunkedOutput
implements PackOutput {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int CHUNK_HEADER_SIZE = 2;
    public static final int MESSAGE_BOUNDARY = 0;
    private static final int MAX_CHUNK_SIZE = 16383;
    private static final int NO_MESSAGE = -1;
    private final Channel channel;
    private final int maxBufferSize;
    private final int maxChunkSize;
    private final TransportThrottleGroup throttleGroup;
    private ByteBuf buffer;
    private int currentChunkStartIndex;
    private boolean closed;
    private boolean chunkOpen;
    private int currentMessageStartIndex = -1;

    public ChunkedOutput(Channel ch, TransportThrottleGroup throttleGroup) {
        this(ch, 8192, throttleGroup);
    }

    public ChunkedOutput(Channel ch, int bufferSize, TransportThrottleGroup throttleGroup) {
        this(ch, bufferSize, 16383, throttleGroup);
    }

    public ChunkedOutput(Channel channel, int maxBufferSize, int maxChunkSize, TransportThrottleGroup throttleGroup) {
        this.channel = Objects.requireNonNull(channel);
        this.maxBufferSize = maxBufferSize;
        this.maxChunkSize = maxChunkSize;
        this.buffer = this.allocateBuffer();
        this.throttleGroup = Objects.requireNonNull(throttleGroup);
    }

    @Override
    public void beginMessage() {
        if (this.currentMessageStartIndex != -1) {
            throw new IllegalStateException("Message has already been started, index: " + this.currentMessageStartIndex);
        }
        this.currentMessageStartIndex = this.buffer.writerIndex();
    }

    @Override
    public void messageSucceeded() throws IOException {
        this.assertMessageStarted();
        this.currentMessageStartIndex = -1;
        this.closeChunkIfOpen();
        this.buffer.writeShort(0);
        if (this.buffer.readableBytes() >= this.maxBufferSize) {
            this.flush();
        }
        this.chunkOpen = false;
    }

    @Override
    public void messageFailed() throws IOException {
        this.assertMessageStarted();
        int writerIndex = this.currentMessageStartIndex;
        this.currentMessageStartIndex = -1;
        this.buffer.capacity(writerIndex);
        this.chunkOpen = false;
    }

    @Override
    public PackOutput flush() throws IOException {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.closeChunkIfOpen();
            try {
                this.throttleGroup.writeThrottle().acquire(this.channel);
            }
            catch (TransportThrottleException ex) {
                throw new BoltIOException((Status)Status.Request.InvalidUsage, ex.getMessage(), ex);
            }
            ByteBuf out = this.buffer;
            this.buffer = null;
            this.channel.writeAndFlush((Object)out, this.channel.voidPromise());
            this.buffer = this.allocateBuffer();
        }
        return this;
    }

    @Override
    public PackOutput writeByte(byte value) throws IOException {
        this.ensure(1);
        this.buffer.writeByte((int)value);
        return this;
    }

    @Override
    public PackOutput writeShort(short value) throws IOException {
        this.ensure(2);
        this.buffer.writeShort((int)value);
        return this;
    }

    @Override
    public PackOutput writeInt(int value) throws IOException {
        this.ensure(4);
        this.buffer.writeInt(value);
        return this;
    }

    @Override
    public PackOutput writeLong(long value) throws IOException {
        this.ensure(8);
        this.buffer.writeLong(value);
        return this;
    }

    @Override
    public PackOutput writeDouble(double value) throws IOException {
        this.ensure(8);
        this.buffer.writeDouble(value);
        return this;
    }

    @Override
    public PackOutput writeBytes(ByteBuffer data) throws IOException {
        while (data.remaining() > 0) {
            this.ensure(1);
            int oldLimit = data.limit();
            data.limit(data.position() + Math.min(this.availableBytesInCurrentChunk(), data.remaining()));
            this.buffer.writeBytes(data);
            data.limit(oldLimit);
        }
        return this;
    }

    @Override
    public PackOutput writeBytes(byte[] data, int offset, int length) throws IOException {
        if (offset + length > data.length) {
            throw new IOException("Asked to write " + length + " bytes, but there is only " + (data.length - offset) + " bytes available in data provided.");
        }
        return this.writeBytes(ByteBuffer.wrap(data, offset, length));
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.closed = true;
            if (this.buffer != null) {
                this.buffer.release();
                this.buffer = null;
            }
        }
    }

    private void ensure(int numberOfBytes) throws IOException {
        this.assertOpen();
        this.assertMessageStarted();
        if (this.chunkOpen) {
            int targetChunkSize = this.currentChunkBodySize() + numberOfBytes + 2;
            if (targetChunkSize > this.maxChunkSize) {
                this.closeChunkIfOpen();
                this.startNewChunk();
            }
        } else {
            this.startNewChunk();
        }
    }

    private void startNewChunk() {
        this.currentChunkStartIndex = this.buffer.writerIndex();
        this.buffer.writeShort(0);
        this.chunkOpen = true;
    }

    private void closeChunkIfOpen() {
        if (this.chunkOpen) {
            int chunkBodySize = this.currentChunkBodySize();
            this.buffer.setShort(this.currentChunkStartIndex, chunkBodySize);
            this.chunkOpen = false;
        }
    }

    private int availableBytesInCurrentChunk() {
        return this.maxChunkSize - this.currentChunkBodySize() - 2;
    }

    private int currentChunkBodySize() {
        return this.buffer.writerIndex() - (this.currentChunkStartIndex + 2);
    }

    private ByteBuf allocateBuffer() {
        return this.channel.alloc().buffer(this.maxBufferSize);
    }

    private void assertMessageStarted() {
        if (this.currentMessageStartIndex == -1) {
            throw new IllegalStateException("Message has not been started");
        }
    }

    private void assertOpen() throws PackOutputClosedException {
        if (this.closed) {
            throw new PackOutputClosedException(String.format("Network channel towards %s is closed. Client has probably been stopped.", this.channel.remoteAddress()), String.format("%s", this.channel.remoteAddress()));
        }
    }
}

