/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Clock;
import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1SPI;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineV1SPI;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.runtime.TransactionStateMachineV3SPI;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.internal.LogService;
import org.neo4j.udc.UsageData;

public class BoltStateMachineFactoryImpl
implements BoltStateMachineFactory {
    private final DatabaseManager databaseManager;
    private final UsageData usageData;
    private final LogService logging;
    private final Authentication authentication;
    private final Config config;
    private final Clock clock;
    private final String activeDatabaseName;

    public BoltStateMachineFactoryImpl(DatabaseManager databaseManager, UsageData usageData, Authentication authentication, Clock clock, Config config, LogService logging) {
        this.databaseManager = databaseManager;
        this.usageData = usageData;
        this.logging = logging;
        this.authentication = authentication;
        this.config = config;
        this.clock = clock;
        this.activeDatabaseName = (String)config.get(GraphDatabaseSettings.active_database);
    }

    @Override
    public BoltStateMachine newStateMachine(long protocolVersion, BoltChannel boltChannel) {
        if (protocolVersion == 1L || protocolVersion == 2L) {
            return this.newStateMachineV1(boltChannel);
        }
        if (protocolVersion == 3L) {
            return this.newStateMachineV3(boltChannel);
        }
        throw new IllegalArgumentException("Failed to create a state machine for protocol version " + protocolVersion);
    }

    private BoltStateMachine newStateMachineV1(BoltChannel boltChannel) {
        TransactionStateMachineV1SPI transactionSPI = new TransactionStateMachineV1SPI((GraphDatabaseAPI)this.getActiveDatabase(), boltChannel, this.getAwaitDuration(), this.clock);
        BoltStateMachineV1SPI boltSPI = new BoltStateMachineV1SPI(this.usageData, this.logging, this.authentication, transactionSPI);
        return new BoltStateMachineV1(boltSPI, boltChannel, this.clock);
    }

    private BoltStateMachine newStateMachineV3(BoltChannel boltChannel) {
        TransactionStateMachineV3SPI transactionSPI = new TransactionStateMachineV3SPI((GraphDatabaseAPI)this.getActiveDatabase(), boltChannel, this.getAwaitDuration(), this.clock);
        BoltStateMachineV1SPI boltSPI = new BoltStateMachineV1SPI(this.usageData, this.logging, this.authentication, transactionSPI);
        return new BoltStateMachineV3(boltSPI, boltChannel, this.clock);
    }

    private Duration getAwaitDuration() {
        long bookmarkReadyTimeout = ((Duration)this.config.get(GraphDatabaseSettings.bookmark_ready_timeout)).toMillis();
        return Duration.ofMillis(bookmarkReadyTimeout);
    }

    private GraphDatabaseFacade getActiveDatabase() {
        return (GraphDatabaseFacade)this.databaseManager.getDatabaseFacade(this.activeDatabaseName).get();
    }
}

