/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ReadyState
extends FailSafeBoltStateMachineState {
    private BoltStateMachineState streamingState;
    private BoltStateMachineState txReadyState;
    static final String FIELDS_KEY = "fields";
    static final String FIRST_RECORD_AVAILABLE_KEY = "t_first";

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof RunMessage) {
            return this.processRunMessage((RunMessage)message, context);
        }
        if (message instanceof BeginMessage) {
            return this.processBeginMessage((BeginMessage)message, context);
        }
        return null;
    }

    @Override
    public String name() {
        return "READY";
    }

    public void setStreamingState(BoltStateMachineState streamingState) {
        this.streamingState = streamingState;
    }

    public void setTransactionReadyState(BoltStateMachineState txReadyState) {
        this.txReadyState = txReadyState;
    }

    private BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws KernelException {
        long start = context.clock().millis();
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        StatementMetadata statementMetadata = statementProcessor.run(message.statement(), message.params(), message.bookmark(), message.transactionTimeout(), message.transactionMetadata());
        long end = context.clock().millis();
        context.connectionState().onMetadata(FIELDS_KEY, (AnyValue)Values.stringArray((String[])statementMetadata.fieldNames()));
        context.connectionState().onMetadata(FIRST_RECORD_AVAILABLE_KEY, (AnyValue)Values.longValue((long)(end - start)));
        return this.streamingState;
    }

    private BoltStateMachineState processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        statementProcessor.beginTransaction(message.bookmark(), message.transactionTimeout(), message.transactionMetadata());
        return this.txReadyState;
    }

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.txReadyState != null ? 1 : 0) != 0, (String)"TransactionReady state not set");
        super.assertInitialized();
    }
}

