/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.decoder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.messaging.decoder.PrimitiveOnlyValueWriter;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class InitMessageDecoder
implements RequestMessageDecoder {
    private final BoltResponseHandler responseHandler;

    public InitMessageDecoder(BoltResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    @Override
    public int signature() {
        return 1;
    }

    @Override
    public BoltResponseHandler responseHandler() {
        return this.responseHandler;
    }

    @Override
    public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
        String userAgent = unpacker.unpackString();
        Map<String, Object> authToken = InitMessageDecoder.readMetaDataMap(unpacker);
        return new InitMessage(userAgent, authToken);
    }

    public static Map<String, Object> readMetaDataMap(Neo4jPack.Unpacker unpacker) throws IOException {
        MapValue metaDataMapValue = unpacker.unpackMap();
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>(metaDataMapValue.size());
        metaDataMapValue.foreach((key, value) -> {
            Object convertedValue = AuthToken.containsSensitiveInformation((String)key) ? writer.sensitiveValueAsObject((AnyValue)value, (String)key) : writer.valueAsObject((AnyValue)value);
            metaDataMap.put((String)key, convertedValue);
        });
        return metaDataMap;
    }
}

