/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.TransportSelectionHandler;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.logging.LogProvider;

public class SocketTransport
implements NettyServer.ProtocolInitializer {
    private final String connector;
    private final ListenSocketAddress address;
    private final SslContext sslCtx;
    private final boolean encryptionRequired;
    private final LogProvider logging;
    private final TransportThrottleGroup throttleGroup;
    private final BoltProtocolFactory boltProtocolFactory;
    private final NetworkConnectionTracker connectionTracker;

    public SocketTransport(String connector, ListenSocketAddress address, SslContext sslCtx, boolean encryptionRequired, LogProvider logging, TransportThrottleGroup throttleGroup, BoltProtocolFactory boltProtocolFactory, NetworkConnectionTracker connectionTracker) {
        this.connector = connector;
        this.address = address;
        this.sslCtx = sslCtx;
        this.encryptionRequired = encryptionRequired;
        this.logging = logging;
        this.throttleGroup = throttleGroup;
        this.boltProtocolFactory = boltProtocolFactory;
        this.connectionTracker = connectionTracker;
    }

    @Override
    public ChannelInitializer<Channel> channelInitializer() {
        return new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) {
                ch.config().setAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
                BoltChannel boltChannel = SocketTransport.this.newBoltChannel(ch);
                SocketTransport.this.connectionTracker.add((TrackedNetworkConnection)boltChannel);
                ch.closeFuture().addListener(future -> SocketTransport.this.connectionTracker.remove((TrackedNetworkConnection)boltChannel));
                SocketTransport.this.throttleGroup.install(ch);
                ch.closeFuture().addListener(future -> SocketTransport.this.throttleGroup.uninstall(ch));
                TransportSelectionHandler transportSelectionHandler = new TransportSelectionHandler(boltChannel, SocketTransport.this.sslCtx, SocketTransport.this.encryptionRequired, false, SocketTransport.this.logging, SocketTransport.this.boltProtocolFactory);
                ch.pipeline().addLast(new ChannelHandler[]{transportSelectionHandler});
            }
        };
    }

    @Override
    public ListenSocketAddress address() {
        return this.address;
    }

    private BoltChannel newBoltChannel(Channel ch) {
        return new BoltChannel(this.connectionTracker.newConnectionId(this.connector), this.connector, ch);
    }
}

