/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.RunMessageChecker;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ReadyState
implements BoltStateMachineState {
    private BoltStateMachineState streamingState;
    private BoltStateMachineState interruptedState;
    private BoltStateMachineState failedState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof RunMessage) {
            return this.processRunMessage((RunMessage)message, context);
        }
        if (message instanceof ResetMessage) {
            return this.processResetMessage(context);
        }
        if (message instanceof InterruptSignal) {
            return this.interruptedState;
        }
        return null;
    }

    @Override
    public String name() {
        return "READY";
    }

    public void setStreamingState(BoltStateMachineState streamingState) {
        this.streamingState = streamingState;
    }

    public void setInterruptedState(BoltStateMachineState interruptedState) {
        this.interruptedState = interruptedState;
    }

    public void setFailedState(BoltStateMachineState failedState) {
        this.failedState = failedState;
    }

    private BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws BoltConnectionFatality {
        try {
            long start = context.clock().millis();
            StatementMetadata statementMetadata = ReadyState.processRunMessage(message, context.connectionState().getStatementProcessor());
            long end = context.clock().millis();
            context.connectionState().onMetadata("fields", (AnyValue)Values.stringArray((String[])statementMetadata.fieldNames()));
            context.connectionState().onMetadata("result_available_after", (AnyValue)Values.longValue((long)(end - start)));
            return this.streamingState;
        }
        catch (AuthorizationExpiredException e) {
            context.handleFailure(e, true);
            return this.failedState;
        }
        catch (Throwable t) {
            context.handleFailure(t, false);
            return this.failedState;
        }
    }

    private static StatementMetadata processRunMessage(RunMessage message, StatementProcessor statementProcessor) throws Exception {
        if (RunMessageChecker.isBegin(message)) {
            Bookmark bookmark = Bookmark.fromParamsOrNull(message.params());
            statementProcessor.beginTransaction(bookmark);
            return StatementMetadata.EMPTY;
        }
        if (RunMessageChecker.isCommit(message)) {
            statementProcessor.commitTransaction();
            return StatementMetadata.EMPTY;
        }
        if (RunMessageChecker.isRollback(message)) {
            statementProcessor.rollbackTransaction();
            return StatementMetadata.EMPTY;
        }
        return statementProcessor.run(message.statement(), message.params());
    }

    private BoltStateMachineState processResetMessage(StateMachineContext context) throws BoltConnectionFatality {
        boolean success = context.resetMachine();
        return success ? this : this.failedState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
    }
}

