/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltConnectionDescriptor;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.v1.runtime.BoltQuerySource;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.StatementMetadata;
import org.neo4j.bolt.v1.runtime.StatementProcessor;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class BoltStateMachine
implements AutoCloseable,
ManagedBoltStateMachine {
    private final String id;
    private final BoltChannel boltChannel;
    private final Clock clock;
    private final Log log;
    State state = State.CONNECTED;
    final SPI spi;
    final MutableConnectionState ctx;

    public BoltStateMachine(SPI spi, BoltChannel boltChannel, Clock clock, LogService logService) {
        this.id = boltChannel.id();
        this.spi = spi;
        this.ctx = new MutableConnectionState(spi, clock);
        this.boltChannel = boltChannel;
        this.clock = clock;
        this.log = logService.getInternalLog(this.getClass());
    }

    public State state() {
        return this.state;
    }

    public StatementProcessor statementProcessor() {
        return this.ctx.statementProcessor;
    }

    private void before(BoltResponseHandler handler) throws BoltConnectionFatality {
        if (this.ctx.isTerminated.get()) {
            this.close();
        } else if (this.ctx.interruptCounter.get() > 0) {
            this.state = this.state.interrupt(this);
        }
        this.ctx.responseHandler = handler;
    }

    private void after() {
        if (this.ctx.responseHandler != null) {
            try {
                Neo4jError pendingError = this.ctx.pendingError;
                if (pendingError != null) {
                    this.ctx.markFailed(pendingError);
                }
                if (this.ctx.pendingIgnore) {
                    this.ctx.markIgnored();
                }
                this.ctx.resetPendingFailedAndIgnored();
                this.ctx.responseHandler.onFinish();
            }
            finally {
                this.ctx.responseHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String userAgent, Map<String, Object> authToken, BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.ctx.canProcessMessage()) {
                this.state = this.state.init(this, userAgent, authToken);
            }
        }
        finally {
            this.after();
        }
    }

    public void ackFailure(BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            this.state = this.state.ackFailure(this);
        }
        finally {
            this.after();
        }
    }

    public void reset(BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.ctx.canProcessMessage()) {
                this.state = this.state.reset(this);
            }
        }
        finally {
            this.after();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String statement, MapValue params, BoltResponseHandler handler) throws BoltConnectionFatality {
        long start = this.clock.millis();
        this.before(handler);
        try {
            if (this.ctx.canProcessMessage()) {
                this.state = this.state.run(this, statement, params);
                handler.onMetadata("result_available_after", (AnyValue)Values.longValue((long)(this.clock.millis() - start)));
            }
        }
        finally {
            this.after();
        }
    }

    public void discardAll(BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.ctx.canProcessMessage()) {
                this.state = this.state.discardAll(this);
            }
        }
        finally {
            this.after();
        }
    }

    public void pullAll(BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.ctx.canProcessMessage()) {
                this.state = this.state.pullAll(this);
            }
        }
        finally {
            this.after();
        }
    }

    public void markFailed(Neo4jError error) {
        BoltStateMachine.fail(this, error);
        this.state = State.FAILED;
    }

    public String key() {
        return this.id;
    }

    public void interrupt() {
        this.ctx.interruptCounter.incrementAndGet();
        this.ctx.statementProcessor.markCurrentTransactionForTermination();
    }

    public void validateTransaction() throws KernelException {
        this.ctx.statementProcessor.validateTransaction();
    }

    public void externalError(Neo4jError error, BoltResponseHandler handler) throws BoltConnectionFatality {
        this.before(handler);
        try {
            if (this.ctx.canProcessMessage()) {
                BoltStateMachine.fail(this, error);
                this.state = State.FAILED;
            }
        }
        finally {
            this.after();
        }
    }

    public boolean isClosed() {
        return this.ctx.closed;
    }

    @Override
    public void close() {
        try {
            this.boltChannel.close();
        }
        finally {
            this.spi.onTerminate(this);
            this.ctx.closed = true;
            this.reset();
        }
    }

    public String owner() {
        return this.ctx.owner;
    }

    public void terminate() {
        this.ctx.isTerminated.set(true);
        this.ctx.statementProcessor.markCurrentTransactionForTermination();
        this.spi.onTerminate(this);
    }

    public boolean willTerminate() {
        return this.ctx.isTerminated.get();
    }

    public boolean shouldStickOnThread() {
        return this.statementProcessor().hasTransaction() || this.statementProcessor().hasOpenStatement();
    }

    public boolean hasOpenStatement() {
        return this.statementProcessor().hasOpenStatement();
    }

    private static State handleFailure(BoltStateMachine machine, Throwable t) throws BoltConnectionFatality {
        return BoltStateMachine.handleFailure(machine, t, false);
    }

    private static State handleFailure(BoltStateMachine machine, Throwable t, boolean fatal) throws BoltConnectionFatality {
        if (ExceptionUtils.indexOfType((Throwable)t, BoltConnectionFatality.class) != -1) {
            fatal = true;
        }
        return BoltStateMachine.handleFailure(machine, t, fatal ? Neo4jError.fatalFrom(t) : Neo4jError.from(t));
    }

    private static State handleFailure(BoltStateMachine machine, Throwable t, Neo4jError error) throws BoltConnectionFatality {
        BoltStateMachine.fail(machine, error);
        if (error.isFatal()) {
            if (ExceptionUtils.indexOfType((Throwable)t, AuthorizationExpiredException.class) != -1) {
                throw new BoltConnectionAuthFatality("Failed to process a bolt message", t);
            }
            if (t instanceof AuthenticationException) {
                throw new BoltConnectionAuthFatality((AuthenticationException)t);
            }
            throw new BoltConnectionFatality("Failed to process a bolt message", t);
        }
        return State.FAILED;
    }

    private static void fail(BoltStateMachine machine, Neo4jError neo4jError) {
        machine.spi.reportError(neo4jError);
        if (machine.state == State.FAILED) {
            machine.ctx.markIgnored();
        } else {
            machine.ctx.markFailed(neo4jError);
        }
    }

    private void reset() {
        try {
            this.ctx.statementProcessor.reset();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NullStatementProcessor
    implements StatementProcessor {
        private NullStatementProcessor() {
        }

        @Override
        public StatementMetadata run(String statement, MapValue params) {
            throw new UnsupportedOperationException("Unable to run any statements.");
        }

        @Override
        public void streamResult(ThrowingConsumer<BoltResult, Exception> resultConsumer) {
            throw new UnsupportedOperationException("Unable to stream any results.");
        }

        @Override
        public void reset() {
        }

        @Override
        public void markCurrentTransactionForTermination() {
        }

        @Override
        public void validateTransaction() {
        }

        @Override
        public boolean hasTransaction() {
            return false;
        }

        @Override
        public boolean hasOpenStatement() {
            return false;
        }

        @Override
        public void setQuerySource(BoltQuerySource querySource) {
        }
    }

    public static interface SPI {
        public void reportError(Neo4jError var1);

        public AuthenticationResult authenticate(Map<String, Object> var1) throws AuthenticationException;

        public void udcRegisterClient(String var1);

        public BoltConnectionDescriptor connectionDescriptor();

        public void register(BoltStateMachine var1, String var2);

        public TransactionStateMachine.SPI transactionSpi();

        public void onTerminate(BoltStateMachine var1);

        public String version();
    }

    static class MutableConnectionState
    implements BoltResponseHandler {
        private static final NullStatementProcessor NULL_STATEMENT_PROCESSOR = new NullStatementProcessor();
        private final SPI spi;
        private final Clock clock;
        BoltResponseHandler responseHandler;
        Neo4jError pendingError;
        boolean pendingIgnore;
        final AtomicInteger interruptCounter = new AtomicInteger();
        final AtomicBoolean isTerminated = new AtomicBoolean(false);
        StatementProcessor statementProcessor = NULL_STATEMENT_PROCESSOR;
        String owner;
        boolean closed;

        MutableConnectionState(SPI spi, Clock clock) {
            this.spi = spi;
            this.clock = clock;
        }

        private void init(AuthenticationResult authenticationResult) {
            this.statementProcessor = new TransactionStateMachine(this.spi.transactionSpi(), authenticationResult, this.clock);
        }

        private void setQuerySourceFromClientNameAndPrincipal(String clientName, String principal, BoltConnectionDescriptor connectionDescriptor) {
            String principalName = principal == null ? "null" : principal;
            this.statementProcessor.setQuerySource(new BoltQuerySource(principalName, clientName, connectionDescriptor));
        }

        @Override
        public void onStart() {
            if (this.responseHandler != null) {
                this.responseHandler.onStart();
            }
        }

        @Override
        public void onRecords(BoltResult result, boolean pull) throws Exception {
            if (this.responseHandler != null) {
                this.responseHandler.onRecords(result, pull);
            }
        }

        @Override
        public void onMetadata(String key, AnyValue value) {
            if (this.responseHandler != null) {
                this.responseHandler.onMetadata(key, value);
            }
        }

        @Override
        public void markIgnored() {
            if (this.responseHandler != null) {
                this.responseHandler.markIgnored();
            } else {
                this.pendingIgnore = true;
            }
        }

        @Override
        public void markFailed(Neo4jError error) {
            if (this.responseHandler != null) {
                this.responseHandler.markFailed(error);
            } else {
                this.pendingError = error;
            }
        }

        @Override
        public void onFinish() {
            if (this.responseHandler != null) {
                this.responseHandler.onFinish();
            }
        }

        private boolean canProcessMessage() {
            return !this.closed && this.pendingError == null && !this.pendingIgnore;
        }

        private void resetPendingFailedAndIgnored() {
            this.pendingError = null;
            this.pendingIgnore = false;
        }
    }

    public static enum State {
        CONNECTED{

            @Override
            public State init(BoltStateMachine machine, String userAgent, Map<String, Object> authToken) throws BoltConnectionFatality {
                try {
                    AuthenticationResult authResult = machine.spi.authenticate(authToken);
                    machine.ctx.init(authResult);
                    if (authResult.credentialsExpired()) {
                        machine.ctx.onMetadata("credentials_expired", (AnyValue)Values.TRUE);
                    }
                    machine.ctx.onMetadata("server", (AnyValue)Values.stringValue((String)machine.spi.version()));
                    machine.spi.udcRegisterClient(userAgent);
                    if (authToken.containsKey("principal")) {
                        machine.ctx.owner = authToken.get("principal").toString();
                    }
                    machine.ctx.setQuerySourceFromClientNameAndPrincipal(userAgent, machine.ctx.owner, machine.spi.connectionDescriptor());
                    if (machine.ctx.owner != null) {
                        machine.spi.register(machine, machine.ctx.owner);
                    }
                    return READY;
                }
                catch (Throwable t) {
                    return BoltStateMachine.handleFailure(machine, t, true);
                }
            }
        }
        ,
        READY{

            @Override
            public State run(BoltStateMachine machine, String statement, MapValue params) throws BoltConnectionFatality {
                try {
                    StatementMetadata statementMetadata = machine.ctx.statementProcessor.run(statement, params);
                    machine.ctx.onMetadata("fields", (AnyValue)Values.stringArray((String[])statementMetadata.fieldNames()));
                    return STREAMING;
                }
                catch (AuthorizationExpiredException e) {
                    return BoltStateMachine.handleFailure(machine, e, true);
                }
                catch (Throwable t) {
                    return BoltStateMachine.handleFailure(machine, t);
                }
            }

            @Override
            public State interrupt(BoltStateMachine machine) {
                return INTERRUPTED;
            }

            @Override
            public State reset(BoltStateMachine machine) throws BoltConnectionFatality {
                return this.resetMachine(machine);
            }
        }
        ,
        STREAMING{

            @Override
            public State interrupt(BoltStateMachine machine) {
                return INTERRUPTED;
            }

            @Override
            public State reset(BoltStateMachine machine) throws BoltConnectionFatality {
                return this.resetMachine(machine);
            }

            @Override
            public State pullAll(BoltStateMachine machine) throws BoltConnectionFatality {
                try {
                    machine.ctx.statementProcessor.streamResult((ThrowingConsumer<BoltResult, Exception>)((ThrowingConsumer)recordStream -> machine.ctx.responseHandler.onRecords((BoltResult)recordStream, true)));
                    return READY;
                }
                catch (AuthorizationExpiredException e) {
                    return BoltStateMachine.handleFailure(machine, e, true);
                }
                catch (Throwable e) {
                    return BoltStateMachine.handleFailure(machine, e);
                }
            }

            @Override
            public State discardAll(BoltStateMachine machine) throws BoltConnectionFatality {
                try {
                    machine.ctx.statementProcessor.streamResult((ThrowingConsumer<BoltResult, Exception>)((ThrowingConsumer)recordStream -> machine.ctx.responseHandler.onRecords((BoltResult)recordStream, false)));
                    return READY;
                }
                catch (AuthorizationExpiredException e) {
                    return BoltStateMachine.handleFailure(machine, e, true);
                }
                catch (Throwable t) {
                    return BoltStateMachine.handleFailure(machine, t);
                }
            }
        }
        ,
        FAILED{

            @Override
            public State interrupt(BoltStateMachine machine) {
                return INTERRUPTED;
            }

            @Override
            public State reset(BoltStateMachine machine) throws BoltConnectionFatality {
                return this.resetMachine(machine);
            }

            @Override
            public State ackFailure(BoltStateMachine machine) {
                machine.ctx.resetPendingFailedAndIgnored();
                return READY;
            }

            @Override
            public State run(BoltStateMachine machine, String statement, MapValue params) {
                machine.ctx.markIgnored();
                return FAILED;
            }

            @Override
            public State pullAll(BoltStateMachine machine) {
                machine.ctx.markIgnored();
                return FAILED;
            }

            @Override
            public State discardAll(BoltStateMachine machine) {
                machine.ctx.markIgnored();
                return FAILED;
            }
        }
        ,
        INTERRUPTED{

            @Override
            public State interrupt(BoltStateMachine machine) {
                return INTERRUPTED;
            }

            @Override
            public State reset(BoltStateMachine machine) throws BoltConnectionFatality {
                if (machine.ctx.interruptCounter.decrementAndGet() > 0) {
                    machine.ctx.markIgnored();
                    return INTERRUPTED;
                }
                return this.resetMachine(machine);
            }

            @Override
            public State ackFailure(BoltStateMachine machine) {
                machine.ctx.markIgnored();
                return INTERRUPTED;
            }

            @Override
            public State run(BoltStateMachine machine, String statement, MapValue params) {
                machine.ctx.markIgnored();
                return INTERRUPTED;
            }

            @Override
            public State pullAll(BoltStateMachine machine) {
                machine.ctx.markIgnored();
                return INTERRUPTED;
            }

            @Override
            public State discardAll(BoltStateMachine machine) {
                machine.ctx.markIgnored();
                return INTERRUPTED;
            }
        };


        public State init(BoltStateMachine machine, String userAgent, Map<String, Object> authToken) throws BoltConnectionFatality {
            String msg = "INIT cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        public State ackFailure(BoltStateMachine machine) throws BoltConnectionFatality {
            String msg = "ACK_FAILURE cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        public State interrupt(BoltStateMachine machine) throws BoltConnectionFatality {
            String msg = "RESET cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        public State reset(BoltStateMachine machine) throws BoltConnectionFatality {
            String msg = "RESET cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        public State run(BoltStateMachine machine, String statement, MapValue params) throws BoltConnectionFatality {
            String msg = "RUN cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        public State discardAll(BoltStateMachine machine) throws BoltConnectionFatality {
            String msg = "DISCARD_ALL cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        public State pullAll(BoltStateMachine machine) throws BoltConnectionFatality {
            String msg = "PULL_ALL cannot be handled by a session in the " + this.name() + " state.";
            BoltStateMachine.fail(machine, Neo4jError.fatalFrom((Status)Status.Request.Invalid, msg));
            throw new BoltProtocolBreachFatality(msg);
        }

        State resetMachine(BoltStateMachine machine) throws BoltConnectionFatality {
            try {
                machine.ctx.statementProcessor.reset();
                return READY;
            }
            catch (Throwable t) {
                return BoltStateMachine.handleFailure(machine, t, true);
            }
        }
    }
}

