/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.function.ThrowingAction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class BoltResponseMessageWriter
implements BoltResponseMessageHandler<IOException> {
    private final PackOutput output;
    private final Neo4jPack.Packer packer;
    private final BoltMessageLogger messageLogger;
    private final Log log;

    public BoltResponseMessageWriter(Neo4jPack neo4jPack, PackOutput output, LogService logService, BoltMessageLogger messageLogger) {
        this.output = output;
        this.packer = neo4jPack.newPacker(output);
        this.messageLogger = messageLogger;
        this.log = logService.getInternalLog(this.getClass());
    }

    @Override
    public void onRecord(QueryResult.Record item) throws IOException {
        this.packCompleteMessageOrFail(BoltResponseMessage.RECORD, (ThrowingAction<IOException>)((ThrowingAction)() -> {
            AnyValue[] fields = item.fields();
            this.packer.packStructHeader(1, BoltResponseMessage.RECORD.signature());
            this.packer.packListHeader(fields.length);
            for (AnyValue field : fields) {
                this.packer.pack(field);
            }
        }));
    }

    @Override
    public void onSuccess(MapValue metadata) throws IOException {
        this.packCompleteMessageOrFail(BoltResponseMessage.SUCCESS, (ThrowingAction<IOException>)((ThrowingAction)() -> {
            this.packer.packStructHeader(1, BoltResponseMessage.SUCCESS.signature());
            this.packer.pack((AnyValue)metadata);
        }));
        this.messageLogger.logSuccess(() -> metadata);
    }

    @Override
    public void onIgnored() throws IOException {
        this.packCompleteMessageOrFail(BoltResponseMessage.IGNORED, (ThrowingAction<IOException>)((ThrowingAction)() -> this.packer.packStructHeader(0, BoltResponseMessage.IGNORED.signature())));
        this.messageLogger.logIgnored();
    }

    @Override
    public void onFailure(Status status, String errorMessage) throws IOException {
        this.packCompleteMessageOrFail(BoltResponseMessage.FAILURE, (ThrowingAction<IOException>)((ThrowingAction)() -> {
            this.packer.packStructHeader(1, BoltResponseMessage.FAILURE.signature());
            this.packer.packMapHeader(2);
            this.packer.pack("code");
            this.packer.pack(status.code().serialize());
            this.packer.pack("message");
            this.packer.pack(errorMessage);
        }));
        this.messageLogger.logFailure(status);
    }

    @Override
    public void onFatal(Status status, String errorMessage) throws IOException {
        this.messageLogger.serverError("FATAL", status);
        this.onFailure(status, errorMessage);
        this.flush();
    }

    public void flush() throws IOException {
        this.packer.flush();
    }

    private void packCompleteMessageOrFail(BoltResponseMessage message, ThrowingAction<IOException> action) throws IOException {
        boolean packingFailed = true;
        this.output.beginMessage();
        try {
            action.apply();
            packingFailed = false;
            this.output.messageSucceeded();
        }
        catch (Throwable error) {
            if (packingFailed) {
                this.output.messageFailed();
                this.log.error("Failed to write full %s message because: %s", new Object[]{message, error.getMessage()});
            }
            throw error;
        }
    }
}

