/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import org.neo4j.bolt.logging.BoltMessageLogging;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstallerFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.TransportSelectionHandler;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.logging.LogProvider;

public class SocketTransport
implements NettyServer.ProtocolInitializer {
    private final String connector;
    private final ListenSocketAddress address;
    private final SslContext sslCtx;
    private final boolean encryptionRequired;
    private final LogProvider logging;
    private final BoltMessageLogging boltLogging;
    private final TransportThrottleGroup throttleGroup;
    private final BoltProtocolPipelineInstallerFactory handlerFactory;

    public SocketTransport(String connector, ListenSocketAddress address, SslContext sslCtx, boolean encryptionRequired, LogProvider logging, BoltMessageLogging boltLogging, TransportThrottleGroup throttleGroup, BoltProtocolPipelineInstallerFactory handlerFactory) {
        this.connector = connector;
        this.address = address;
        this.sslCtx = sslCtx;
        this.encryptionRequired = encryptionRequired;
        this.logging = logging;
        this.boltLogging = boltLogging;
        this.throttleGroup = throttleGroup;
        this.handlerFactory = handlerFactory;
    }

    @Override
    public ChannelInitializer<SocketChannel> channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.config().setAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
                SocketTransport.this.throttleGroup.install((Channel)ch);
                ch.closeFuture().addListener(future -> SocketTransport.this.throttleGroup.uninstall((Channel)ch));
                TransportSelectionHandler transportSelectionHandler = new TransportSelectionHandler(SocketTransport.this.connector, SocketTransport.this.sslCtx, SocketTransport.this.encryptionRequired, false, SocketTransport.this.logging, SocketTransport.this.handlerFactory, SocketTransport.this.boltLogging);
                ch.pipeline().addLast(new ChannelHandler[]{transportSelectionHandler});
            }
        };
    }

    @Override
    public ListenSocketAddress address() {
        return this.address;
    }
}

