/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.neo4j.bolt.transport.configuration.EpollConfigurationProvider;
import org.neo4j.bolt.transport.configuration.NioConfigurationProvider;
import org.neo4j.bolt.transport.configuration.ServerConfigurationProvider;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.PortBindException;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.util.FeatureToggles;

public class NettyServer
extends LifecycleAdapter {
    private static final boolean USE_EPOLL = FeatureToggles.flag(NettyServer.class, (String)"useEpoll", (boolean)true);
    private static final int NUM_SELECTOR_THREADS = Math.max(1, Integer.getInteger("org.neo4j.selectorThreads", Runtime.getRuntime().availableProcessors() * 2));
    private final Map<BoltConnector, ProtocolInitializer> bootstrappersMap;
    private final ThreadFactory tf;
    private final ConnectorPortRegister connectionRegister;
    private final Log log;
    private EventLoopGroup bossGroup;
    private EventLoopGroup selectorGroup;

    public NettyServer(ThreadFactory tf, Map<BoltConnector, ProtocolInitializer> initializersMap, ConnectorPortRegister connectorRegister, Log log) {
        this.bootstrappersMap = initializersMap;
        this.tf = tf;
        this.connectionRegister = connectorRegister;
        this.log = log;
    }

    public void start() throws Throwable {
        boolean useEpoll = USE_EPOLL && Epoll.isAvailable();
        ServerConfigurationProvider configurationProvider = useEpoll ? EpollConfigurationProvider.INSTANCE : NioConfigurationProvider.INSTANCE;
        this.bossGroup = configurationProvider.createEventLoopGroup(1, this.tf);
        this.selectorGroup = configurationProvider.createEventLoopGroup(NUM_SELECTOR_THREADS, this.tf);
        for (Map.Entry<BoltConnector, ProtocolInitializer> bootstrapEntry : this.bootstrappersMap.entrySet()) {
            try {
                ProtocolInitializer protocolInitializer = bootstrapEntry.getValue();
                BoltConnector boltConnector = bootstrapEntry.getKey();
                ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).group(this.bossGroup, this.selectorGroup).channel(configurationProvider.getChannelClass())).childHandler(protocolInitializer.channelInitializer()).bind((SocketAddress)protocolInitializer.address().socketAddress()).sync();
                InetSocketAddress localAddress = (InetSocketAddress)channelFuture.channel().localAddress();
                this.connectionRegister.register(boltConnector.key(), localAddress);
                String host = protocolInitializer.address().getHostname();
                int port = localAddress.getPort();
                if (host.contains(":")) {
                    this.log.info("Bolt enabled on [%s]:%s.", new Object[]{host, port});
                    continue;
                }
                this.log.info("Bolt enabled on %s:%s.", new Object[]{host, port});
            }
            catch (Throwable e) {
                throw new PortBindException(bootstrapEntry.getValue().address(), e);
            }
        }
    }

    public void stop() {
        this.bossGroup.shutdownGracefully();
        this.selectorGroup.shutdownGracefully();
    }

    public static interface ProtocolInitializer {
        public ChannelInitializer<SocketChannel> channelInitializer();

        public ListenSocketAddress address();
    }
}

