/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitor;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitorAggregate;
import org.neo4j.bolt.runtime.BoltScheduler;
import org.neo4j.bolt.runtime.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.DefaultBoltConnection;
import org.neo4j.bolt.runtime.MetricsReportingBoltConnection;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.transport.ChunkedOutput;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.Monitors;

public class DefaultBoltConnectionFactory
implements BoltConnectionFactory {
    private final BoltFactory machineFactory;
    private final BoltSchedulerProvider schedulerProvider;
    private final TransportThrottleGroup throttleGroup;
    private final LogService logService;
    private final Clock clock;
    private final BoltConnectionQueueMonitor queueMonitor;
    private final Monitors monitors;
    private final BoltConnectionMetricsMonitor metricsMonitor;

    public DefaultBoltConnectionFactory(BoltFactory machineFactory, BoltSchedulerProvider schedulerProvider, TransportThrottleGroup throttleGroup, LogService logService, Clock clock, BoltConnectionQueueMonitor queueMonitor, Monitors monitors) {
        this.machineFactory = machineFactory;
        this.schedulerProvider = schedulerProvider;
        this.throttleGroup = throttleGroup;
        this.logService = logService;
        this.clock = clock;
        this.queueMonitor = queueMonitor;
        this.monitors = monitors;
        this.metricsMonitor = (BoltConnectionMetricsMonitor)monitors.newMonitor(BoltConnectionMetricsMonitor.class, new String[0]);
    }

    @Override
    public BoltConnection newConnection(BoltChannel channel) {
        BoltScheduler scheduler = this.schedulerProvider.get(channel);
        BoltConnectionQueueMonitor connectionQueueMonitor = this.queueMonitor == null ? scheduler : new BoltConnectionQueueMonitorAggregate(scheduler, this.queueMonitor);
        ChunkedOutput chunkedOutput = new ChunkedOutput(channel.rawChannel(), this.throttleGroup);
        DefaultBoltConnection connection = this.monitors.hasListeners(BoltConnectionMetricsMonitor.class) ? new MetricsReportingBoltConnection(channel, chunkedOutput, this.machineFactory.newMachine(channel, this.clock), this.logService, scheduler, connectionQueueMonitor, this.metricsMonitor, this.clock) : new DefaultBoltConnection(channel, chunkedOutput, this.machineFactory.newMachine(channel, this.clock), this.logService, scheduler, connectionQueueMonitor);
        connection.start();
        return connection;
    }
}

