/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.neo4j.bolt.BoltConnectionDescriptor;
import org.neo4j.bolt.logging.BoltMessageLogger;

public class BoltChannel
implements AutoCloseable,
BoltConnectionDescriptor {
    private final String connector;
    private final Channel rawChannel;
    private final BoltMessageLogger messageLogger;

    public static BoltChannel open(String connector, Channel rawChannel, BoltMessageLogger messageLogger) {
        return new BoltChannel(connector, rawChannel, messageLogger);
    }

    private BoltChannel(String connector, Channel rawChannel, BoltMessageLogger messageLogger) {
        this.connector = connector;
        this.rawChannel = rawChannel;
        this.messageLogger = messageLogger;
        messageLogger.serverEvent("OPEN");
    }

    public Channel rawChannel() {
        return this.rawChannel;
    }

    public BoltMessageLogger log() {
        return this.messageLogger;
    }

    @Override
    public void close() {
        Channel rawChannel = this.rawChannel();
        if (rawChannel.isOpen()) {
            this.messageLogger.serverEvent("CLOSE");
            rawChannel.close().syncUninterruptibly();
        }
    }

    @Override
    public String id() {
        return this.rawChannel().id().asLongText();
    }

    @Override
    public String connector() {
        return this.connector;
    }

    @Override
    public SocketAddress clientAddress() {
        return this.rawChannel.remoteAddress();
    }

    @Override
    public SocketAddress serverAddress() {
        return this.rawChannel.localAddress();
    }
}

