/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import java.util.List;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.TypeMarker;

public class UnexpectedTypeException
extends PackstreamReaderException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final Type expected;
    private final Type actual;

    private UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, Type expected, Type actual) {
        super(gqlStatusObject, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("Unexpected type: Expected " + String.valueOf((Object)expected) + " but got " + String.valueOf((Object)actual))), "Unexpected type: Expected " + String.valueOf((Object)expected) + " but got " + String.valueOf((Object)actual));
        this.expected = expected;
        this.actual = actual;
    }

    private UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, Type actual) {
        super(gqlStatusObject, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("Unexpected type: " + String.valueOf((Object)actual))), "Unexpected type: " + String.valueOf((Object)actual));
        this.expected = null;
        this.actual = actual;
    }

    private UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, Type expected, TypeMarker actual) {
        this(gqlStatusObject, expected, actual.getType());
    }

    protected UnexpectedTypeException(ErrorGqlStatusObject gqlStatusObject, String message, Type expected, Type actual) {
        super(gqlStatusObject, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)message), message);
        this.expected = expected;
        this.actual = actual;
    }

    public static UnexpectedTypeException wrongType(String value, List<String> expectedValueTypeList, Type actual) {
        return new UnexpectedTypeException(GqlHelper.getGql22G03_22N01((String)value, expectedValueTypeList, (String)String.valueOf((Object)actual)), actual);
    }

    public static UnexpectedTypeException invalidType(Type expected, TypeMarker actual) {
        return new UnexpectedTypeException(GqlHelper.getGql22G03_22N01((String)String.valueOf(actual.getValue()), List.of(expected.toString()), (String)actual.getType().toString()), expected, actual);
    }

    public Type getExpected() {
        return this.expected;
    }

    public Type getActual() {
        return this.actual;
    }

    public Status status() {
        return Status.Request.Invalid;
    }
}

