/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx.error;

import org.neo4j.bolt.tx.error.TransactionCreationException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.kernel.api.exceptions.Status;

public class DatabaseUnavailableTransactionCreationException
extends TransactionCreationException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    private DatabaseUnavailableTransactionCreationException(ErrorGqlStatusObject gqlStatusObject, String databaseName, Throwable cause) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)String.format("Database '%s' is unavailable.", databaseName)), cause);
        this.gqlStatusObject = GqlHelper.getInnerGqlStatusObject((ErrorGqlStatusObject)gqlStatusObject, (Throwable)cause);
        this.oldMessage = String.format("Database '%s' is unavailable.", databaseName);
    }

    public static DatabaseUnavailableTransactionCreationException databaseUnavailable(String databaseName, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.getGql08N09((String)databaseName);
        return new DatabaseUnavailableTransactionCreationException(gql, databaseName, cause);
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public Status status() {
        return Status.General.DatabaseUnavailable;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

