/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.error;

import java.io.IOException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class AuthenticationException
extends IOException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final Status status;
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    private AuthenticationException(ErrorGqlStatusObject gqlStatusObject, Status status) {
        this(gqlStatusObject, status, status.code().description(), null);
    }

    public AuthenticationException(ErrorGqlStatusObject gqlStatusObject, Status status, String message) {
        this(gqlStatusObject, status, message, null);
    }

    private AuthenticationException(ErrorGqlStatusObject gqlStatusObject, Status status, String message, Throwable e) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)message), e);
        this.status = status;
        this.gqlStatusObject = GqlHelper.getInnerGqlStatusObject((ErrorGqlStatusObject)gqlStatusObject, (Throwable)e);
        this.oldMessage = message;
    }

    public static AuthenticationException internalError(String msgTitle, String message, Status status) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new AuthenticationException(gql, status, message);
    }

    public static AuthenticationException unauthorized() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthenticationException(gql, (Status)Status.Security.Unauthorized);
    }

    public static AuthenticationException rateLimit() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NFF).build();
        return new AuthenticationException(gql, (Status)Status.Security.AuthenticationRateLimit);
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public Status status() {
        return this.status;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

