/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler.listeners;

import io.netty.channel.ChannelHandler;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.handler.messages.ResetMessageHandler;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class ResetMessageConnectionListener
implements ConnectionListener {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ResetMessageHandler.class);
    private final InternalLogProvider logger;
    private final Connection connection;
    private ResetMessageHandler resetMessageHandler;

    public ResetMessageConnectionListener(InternalLogProvider logger, Connection connection) {
        this.logger = logger;
        this.connection = connection;
    }

    @Override
    public void onLogon(LoginContext ctx) {
        this.connection.memoryTracker().allocateHeap(ResetMessageHandler.SHALLOW_SIZE);
        ResetMessageHandler resetMessageHandler = this.resetMessageHandler = new ResetMessageHandler(this.logger);
        this.connection.modifyPipeline(pipeline -> pipeline.addBefore("goodbyeMessageHandler", "resetMessageHandler", (ChannelHandler)resetMessageHandler));
    }

    @Override
    public void onLogoff() {
        ResetMessageHandler resetMessageHandler = this.resetMessageHandler;
        if (resetMessageHandler != null) {
            this.connection.modifyPipeline(pipeline -> pipeline.remove((ChannelHandler)resetMessageHandler));
        }
        this.resetMessageHandler = null;
    }
}

