/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.config;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.connector.config.AbstractNettyConnectorConfiguration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;

public final class DomainSocketConnectorConfiguration
extends AbstractNettyConnectorConfiguration {
    private final Set<PosixFilePermission> socketFilePermissionMask;
    private final boolean deleteSocketFile;
    private final boolean permitUserDatabaseAccess;

    private DomainSocketConnectorConfiguration(Factory builder) {
        super(builder);
        this.socketFilePermissionMask = builder.socketFilePermissionMask;
        this.permitUserDatabaseAccess = builder.permitUserDatabaseAccess;
        this.deleteSocketFile = builder.deleteSocketFile;
    }

    public static Factory factory() {
        return new Factory();
    }

    public static DomainSocketConnectorConfiguration newInstance() {
        return DomainSocketConnectorConfiguration.factory().build();
    }

    public static DomainSocketConnectorConfiguration create(Consumer<Factory> configurer) {
        Factory factory = DomainSocketConnectorConfiguration.factory();
        configurer.accept(factory);
        return factory.build();
    }

    public boolean deleteSocketFile() {
        return this.deleteSocketFile;
    }

    public Set<PosixFilePermission> socketFilePermissionMask() {
        return this.socketFilePermissionMask;
    }

    public boolean permitUserDatabaseAccess() {
        return this.permitUserDatabaseAccess;
    }

    public static final class Factory
    extends AbstractNettyConnectorConfiguration.AbstractFactory<Factory> {
        private Set<PosixFilePermission> socketFilePermissionMask;
        private boolean deleteSocketFile;
        private boolean permitUserDatabaseAccess;

        private Factory() {
        }

        @Override
        public DomainSocketConnectorConfiguration build() {
            return new DomainSocketConnectorConfiguration(this);
        }

        @Override
        public Factory fromConfig(Config config) {
            this.socketFilePermissionMask = ((BoltConnector.FilePermission)config.get(BoltConnector.unix_socket_permission_mask)).getPosixPermissions();
            this.permitUserDatabaseAccess = (Boolean)config.get(GraphDatabaseInternalSettings.enable_aura_profile) != false || (Boolean)config.get(BoltConnectorInternalSettings.enable_unix_socket_user_database_access) != false;
            this.deleteSocketFile = (Boolean)config.get(BoltConnector.unix_socket_delete);
            return (Factory)super.fromConfig(config);
        }

        public Factory deleteSocketFile(boolean deleteSocketFile) {
            this.deleteSocketFile = deleteSocketFile;
            return this;
        }

        public Factory permitUserDatabaseAccess(boolean permitUserDatabaseAccess) {
            this.permitUserDatabaseAccess = permitUserDatabaseAccess;
            return this;
        }

        public Factory socketFilePermissionMask(Set<PosixFilePermission> socketFilePermissionMask) {
            this.socketFilePermissionMask = socketFilePermissionMask;
            return this;
        }
    }
}

