/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.util;

import io.netty.buffer.ByteBuf;
import org.neo4j.bolt.negotiation.util.BitMask;

public final class NegotiationEncodingUtil {
    private NegotiationEncodingUtil() {
    }

    public static void writeBitMask(ByteBuf buf, BitMask mask) {
        int totalBits = mask.length();
        int encodedLength = totalBits / 7 + (totalBits % 7 == 0 ? 0 : 1);
        for (int i = 0; i < encodedLength; ++i) {
            int b = mask.readN(Math.min(7, mask.readable()));
            if (i + 1 < encodedLength) {
                b ^= 0x80;
            }
            buf.writeByte(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBitMaskReadable(ByteBuf buf, int limit) {
        int readerIndex = buf.readerIndex();
        try {
            for (int i = 0; i < limit; ++i) {
                if (!buf.isReadable()) {
                    boolean bl = false;
                    return bl;
                }
                byte recv = buf.readByte();
                if ((recv & 0x80) != 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            buf.readerIndex(readerIndex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitMask readBitMask(ByteBuf buf) {
        ByteBuf recv = buf.alloc().buffer();
        try {
            byte i;
            do {
                i = buf.readByte();
                recv.writeByte((int)i);
            } while ((i & 0x80) != 0);
            BitMask mask = new BitMask(buf.alloc(), recv.readableBytes() * 7);
            do {
                byte b = recv.readByte();
                mask.writeN(b, 7);
            } while (recv.isReadable());
            BitMask bitMask = mask;
            return bitMask;
        }
        finally {
            recv.release();
        }
    }

    public static void writeVarInt(ByteBuf buf, int value) {
        do {
            int b = value & 0x7F;
            if ((value >>>= 7) != 0) {
                b ^= 0x80;
            }
            buf.writeByte(b);
        } while (value != 0);
    }
}

