/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v52;

import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.AbstractBoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.AuthenticationStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.LogoffStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.CreateAutocommitStatementStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.CreateTransactionStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.RouteStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.TelemetryStateTransition;
import org.neo4j.bolt.protocol.common.message.decoder.generic.TelemetryMessageDecoder;
import org.neo4j.bolt.protocol.common.message.encoder.FailureMessageEncoder;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.reader.DateReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeZoneIdReader;
import org.neo4j.bolt.protocol.io.reader.DurationReader;
import org.neo4j.bolt.protocol.io.reader.LocalDateTimeReader;
import org.neo4j.bolt.protocol.io.reader.LocalTimeReader;
import org.neo4j.bolt.protocol.io.reader.Point2dReader;
import org.neo4j.bolt.protocol.io.reader.Point3dReader;
import org.neo4j.bolt.protocol.io.reader.TimeReader;
import org.neo4j.bolt.protocol.io.writer.VectorBarrierStructWriter;
import org.neo4j.bolt.protocol.v40.message.encoder.FailureMessageEncoderV40;
import org.neo4j.bolt.protocol.v44.fsm.response.metadata.MetadataHandlerV44;
import org.neo4j.bolt.protocol.v52.message.decoder.authentication.HelloMessageDecoderV52;
import org.neo4j.bolt.protocol.v52.message.decoder.transaction.BeginMessageDecoderV52;
import org.neo4j.bolt.protocol.v52.message.decoder.transaction.RunMessageDecoderV52;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.values.storable.Value;

public final class BoltProtocolV52
extends AbstractBoltProtocol {
    private static final BoltProtocolV52 INSTANCE = new BoltProtocolV52();
    public static final ProtocolVersion VERSION = new ProtocolVersion(5, 2);

    public static BoltProtocolV52 getInstance() {
        return INSTANCE;
    }

    private BoltProtocolV52() {
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected StructRegistry.Builder<Connection, RequestMessage> createRequestMessageRegistry() {
        return super.createRequestMessageRegistry().register(HelloMessageDecoderV52.getInstance()).register(BeginMessageDecoderV52.getInstance()).register(RunMessageDecoderV52.getInstance()).unregister(TelemetryMessageDecoder.getInstance());
    }

    @Override
    protected StructRegistry.Builder<Connection, ResponseMessage> createResponseMessageRegistry() {
        return super.createResponseMessageRegistry().unregister(FailureMessageEncoder.getInstance()).register(FailureMessageEncoderV40.getInstance());
    }

    @Override
    protected StateMachineConfiguration.Factory createStateMachine() {
        return super.createStateMachine().withState(States.AUTHENTICATION, AuthenticationStateTransition.getInstance()).withState(States.READY, CreateTransactionStateTransition.getInstance(), RouteStateTransition.getInstance(), CreateAutocommitStatementStateTransition.getInstance(), LogoffStateTransition.getInstance(), TelemetryStateTransition.getInstance());
    }

    @Override
    public void registerStructReaders(StructRegistry.Builder<Connection, Value> builder) {
        builder.register(DateReader.getInstance()).register(DurationReader.getInstance()).register(LocalDateTimeReader.getInstance()).register(LocalTimeReader.getInstance()).register(Point2dReader.getInstance()).register(Point3dReader.getInstance()).register(TimeReader.getInstance()).register(DateTimeReader.getInstance()).register(DateTimeZoneIdReader.getInstance());
    }

    @Override
    public void registerStructWriters(WriterPipeline pipeline) {
        pipeline.addLast(VectorBarrierStructWriter.getInstance());
        super.registerStructWriters(pipeline);
    }

    @Override
    public MetadataHandler metadataHandler() {
        return MetadataHandlerV44.getInstance();
    }
}

