/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;

public class DefaultBoltProtocolRegistry
implements BoltProtocolRegistry {
    private final List<BoltProtocol> protocols;

    private DefaultBoltProtocolRegistry(List<BoltProtocol> protocols) {
        this.protocols = protocols;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public BoltProtocolRegistry.Builder builderOf() {
        return new Builder(this.protocols);
    }

    @Override
    public Optional<BoltProtocol> get(ProtocolVersion protocolVersion) {
        return this.protocols.stream().filter(protocol -> protocolVersion.matches(protocol.version())).max(Comparator.comparing(BoltProtocol::version));
    }

    @Override
    public List<ProtocolVersion> versionsAvailable() {
        return this.protocols.stream().map(BoltProtocol::version).collect(Collectors.toList());
    }

    public static class Builder
    implements BoltProtocolRegistry.Builder {
        private final List<BoltProtocol> protocols;

        private Builder() {
            this.protocols = new ArrayList<BoltProtocol>();
        }

        private Builder(List<BoltProtocol> protocols) {
            this.protocols = new ArrayList<BoltProtocol>(protocols);
        }

        @Override
        public DefaultBoltProtocolRegistry build() {
            return new DefaultBoltProtocolRegistry(List.copyOf(this.protocols));
        }

        @Override
        public Builder register(BoltProtocol protocol) {
            this.protocols.removeIf(registered -> registered.version().matches(protocol.version()));
            this.protocols.add(protocol);
            return this;
        }
    }
}

