/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.handler;

import io.netty.channel.ChannelHandlerContext;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.codec.ModernProtocolNegotiationFinalizeMessageDecoder;
import org.neo4j.bolt.negotiation.codec.ModernProtocolNegotiationInitMessageEncoder;
import org.neo4j.bolt.negotiation.handler.AbstractProtocolHandshakeHandler;
import org.neo4j.bolt.negotiation.message.ModernProtocolNegotiationFinalizeMessage;
import org.neo4j.bolt.negotiation.message.ModernProtocolNegotiationInitMessage;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public final class ModernProtocolHandshakeHandler
extends AbstractProtocolHandshakeHandler<ModernProtocolNegotiationFinalizeMessage> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ModernProtocolHandshakeHandler.class);
    private BoltProtocolRegistry protocolRegistry;

    public ModernProtocolHandshakeHandler(InternalLogProvider logging) {
        super(logging);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.protocolRegistry = this.connector.protocolRegistry();
        List<ProtocolVersion> versions = this.protocolRegistry.versionsAvailable();
        ctx.writeAndFlush((Object)new ModernProtocolNegotiationInitMessage(ProtocolVersion.NEGOTIATION_V2, versions, this.connector.supportedCapabilities()));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ModernProtocolNegotiationFinalizeMessage msg) throws Exception {
        if (ProtocolVersion.INVALID.equals(msg.selectedVersion())) {
            this.log.debug("Failed Bolt handshake: Client does not support any of the proposed Bolt versions supported by this server.");
            ctx.close();
            return;
        }
        BoltProtocol selectedProtocol = this.protocolRegistry.get(msg.selectedVersion()).orElse(null);
        if (selectedProtocol == null) {
            this.log.debug("Failed Bolt handshake: Bolt version suggested by client '%s' are not supported by this server.", new Object[]{msg.selectedVersion()});
            ctx.close();
            return;
        }
        Set<ProtocolCapability> connectorCapabilities = this.connector.supportedCapabilities();
        if (msg.capabilities().stream().anyMatch(capability -> !connectorCapabilities.contains(capability))) {
            String mismatch = msg.capabilities().stream().filter(capability -> !connectorCapabilities.contains(capability)).map(Enum::name).collect(Collectors.joining(", "));
            this.log.debug("Failed Bolt handshake: One or more capabilities suggested by client '%s' are not supported by this connector.", new Object[]{mismatch});
            ctx.close();
            return;
        }
        EnumSet<ProtocolCapability> capabilities = EnumSet.copyOf(msg.capabilities());
        capabilities.add(ProtocolCapability.HANDSHAKE_V2);
        this.finalizeHandshake(ctx, selectedProtocol, capabilities);
    }

    @Override
    protected void removeStageHandlers(ChannelHandlerContext ctx) {
        super.removeStageHandlers(ctx);
        ctx.pipeline().remove(ModernProtocolNegotiationInitMessageEncoder.class);
        ctx.pipeline().remove(ModernProtocolNegotiationFinalizeMessageDecoder.class);
    }
}

