/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.struct;

import java.util.Arrays;
import java.util.List;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.PackstreamStructException;
import org.neo4j.util.VisibleForTesting;

public class IllegalStructArgumentException
extends PackstreamStructException {
    private final String fieldName;

    private IllegalStructArgumentException(ErrorGqlStatusObject gqlStatusObject, String fieldName, PackstreamReaderException cause) {
        super(gqlStatusObject, String.format("Illegal value for field \"%s\": %s", fieldName, cause.getMessage()), cause);
        this.fieldName = fieldName;
    }

    private IllegalStructArgumentException(ErrorGqlStatusObject gqlStatusObject, String fieldName, Throwable cause) {
        super(gqlStatusObject, String.format("Illegal value for field \"%s\"", fieldName), cause);
        this.fieldName = fieldName;
    }

    @VisibleForTesting
    public IllegalStructArgumentException(ErrorGqlStatusObject gqlStatusObject, String fieldName, String message, Throwable cause) {
        super(gqlStatusObject, String.format("Illegal value for field \"%s\": %s", fieldName, message), cause);
        this.fieldName = fieldName;
    }

    private IllegalStructArgumentException(ErrorGqlStatusObject gqlStatusObject, String fieldName, String message) {
        this(gqlStatusObject, fieldName, message, null);
    }

    public static IllegalStructArgumentException protocolError(String fieldName, PackstreamReaderException cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N06).build();
        return new IllegalStructArgumentException(gql, fieldName, cause);
    }

    public static IllegalStructArgumentException invalidInput(String fieldName, String input, String context, List<String> expectedInputList, Throwable cause) {
        return new IllegalStructArgumentException(GqlHelper.getGql08N06_22N04((String)input, (String)context, expectedInputList), fieldName, cause);
    }

    public static IllegalStructArgumentException invalidCoordinateArguments(String fieldName, String valueType, double[] coordinates, String message, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N06).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N24).withParam(GqlParams.StringParam.valueType, valueType).withParam(GqlParams.StringParam.coordinates, Arrays.toString(coordinates)).build()).build();
        return new IllegalStructArgumentException(gql, fieldName, message, cause);
    }

    public static IllegalStructArgumentException invalidCRS(String crsCode, Neo4jException cause) {
        ErrorGqlStatusObject gql;
        if (GqlHelper.causeChainContains((ErrorGqlStatusObject)cause, (GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N21)) {
            gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N06).build();
        } else {
            ErrorGqlStatusObject gqlCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N21).withParam(GqlParams.StringParam.crs, crsCode).build();
            gql = GqlHelper.getGql08N06((ErrorGqlStatusObject)gqlCause);
        }
        return new IllegalStructArgumentException(gql, "crs", String.format("Illegal coordinate reference system: \"%s\"", crsCode), (Throwable)cause);
    }

    public static IllegalStructArgumentException crsOutOfBounds() {
        ErrorGqlStatusObject gql = GqlHelper.getGql08N06((ErrorGqlStatusObject)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N29).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, "crs").build()).build());
        return new IllegalStructArgumentException(gql, "crs", "crs code exceeds valid bounds");
    }

    public static IllegalStructArgumentException invalidTemporalComponent(String fieldName, long epochSecond, long nanos, Throwable cause) {
        ErrorGqlStatusObject gqlCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N15).withParam(GqlParams.StringParam.component, fieldName).withParam(GqlParams.StringParam.temporal, epochSecond + "+" + nanos).build();
        return new IllegalStructArgumentException(GqlHelper.getGql08N06((ErrorGqlStatusObject)gqlCause), fieldName, String.format("Illegal epoch adjustment epoch seconds: %d+%d", epochSecond, nanos), cause);
    }

    public static IllegalStructArgumentException invalidZoneId(String zoneName, Throwable cause) {
        ErrorGqlStatusObject gqlCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB5).withParam(GqlParams.StringParam.input, zoneName).build();
        return new IllegalStructArgumentException(GqlHelper.getGql08N06((ErrorGqlStatusObject)gqlCause), "tz_id", String.format("Illegal zone identifier: \"%s\"", zoneName), cause);
    }

    public static IllegalStructArgumentException wrongTypeForFieldName(String fieldName, String value, List<String> expectedType, String actualType, String message) {
        return new IllegalStructArgumentException(GqlHelper.getGql08N06((ErrorGqlStatusObject)GqlHelper.getGql22G03_22N01((String)value, expectedType, (String)actualType)), fieldName, message);
    }

    public static IllegalStructArgumentException wrongTypeForFieldNameOrOutOfRange(String fieldName, String expectedType, Number lowerLimit, Number upperLimit, Number actualValue, String message) {
        ErrorGqlStatusObject gql = GqlHelper.getGql08N06((ErrorGqlStatusObject)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N03).withParam(GqlParams.StringParam.component, fieldName).withParam(GqlParams.StringParam.valueType, expectedType).withParam(GqlParams.StringParam.lower, String.valueOf(lowerLimit)).withParam(GqlParams.StringParam.upper, String.valueOf(upperLimit)).withParam(GqlParams.StringParam.value, String.valueOf(actualValue)).build());
        return new IllegalStructArgumentException(gql, fieldName, message);
    }

    public static IllegalStructArgumentException invalidInput(String fieldName, String input, String context, List<String> expectedInputList, String message) {
        return new IllegalStructArgumentException(GqlHelper.getGql08N06_22N04((String)input, (String)context, expectedInputList), fieldName, message);
    }

    public static IllegalStructArgumentException expectedMapToHaveKey(String mapKey, String field) {
        ErrorGqlStatusObject gql = GqlHelper.getGql08N06((ErrorGqlStatusObject)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N55).withParam(GqlParams.StringParam.mapKey, mapKey).withParam(GqlParams.StringParam.field, field).build());
        return new IllegalStructArgumentException(gql, field, String.format("Expected map to contain key: '%s'.", mapKey));
    }

    public static IllegalStructArgumentException expectedIntegerButGotNull(String fieldName) {
        return new IllegalStructArgumentException(GqlHelper.getGql08N06((ErrorGqlStatusObject)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, "null").withParam(GqlParams.StringParam.context, String.format("field '%s'", fieldName)).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22004).build()).build()), fieldName, "Expected Integer but nothing was sent with the message");
    }

    public static IllegalStructArgumentException expectedNonNullValue(String fieldName) {
        return new IllegalStructArgumentException(GqlHelper.getGql08N06((ErrorGqlStatusObject)ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, "null").withParam(GqlParams.StringParam.context, String.format("field '%s'", fieldName)).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22004).build()).build()), fieldName, "Expected value to be non-null");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Status status() {
        Throwable cause = this.getCause();
        if (cause instanceof PackstreamReaderException && cause instanceof Status.HasStatus) {
            return ((Status.HasStatus)cause).status();
        }
        return Status.Request.Invalid;
    }
}

