/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationRequestDecoder;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationResponseEncoder;
import org.neo4j.bolt.negotiation.handler.LegacyProtocolHandshakeHandler;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.handler.DiscoveryResponseHandler;
import org.neo4j.bolt.protocol.common.handler.ProtocolLoggingHandler;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.codec.transport.WebSocketFramePackingEncoder;
import org.neo4j.packstream.codec.transport.WebSocketFrameUnpackingDecoder;
import org.neo4j.util.VisibleForTesting;

public class TransportSelectionHandler
extends ByteToMessageDecoder {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransportSelectionHandler.class);
    public static final long SSL_HANDLER_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SslHandler.class);
    public static final long HTTP_SERVER_CODEC_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HttpServerCodec.class);
    public static final long HTTP_OBJECT_AGGREGATOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HttpObjectAggregator.class);
    public static final long WEB_SOCKET_SERVER_PROTOCOL_HANDLER_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(WebSocketServerProtocolHandler.class);
    public static final long WEB_SOCKET_FRAME_AGGREGATOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(WebSocketFrameAggregator.class);
    private static final String WEBSOCKET_MAGIC = "GET ";
    private static final int MAX_WEBSOCKET_HANDSHAKE_SIZE = 65536;
    private static final int MAX_WEBSOCKET_FRAME_SIZE = 65536;
    private final InternalLogProvider logging;
    private final InternalLog log;
    private final boolean isEncrypted;
    private AbstractNettyConnector<?> connector;
    private Connection connection;

    @VisibleForTesting
    TransportSelectionHandler(boolean isEncrypted, InternalLogProvider logging) {
        this.isEncrypted = isEncrypted;
        this.logging = logging;
        this.log = logging.getLog(TransportSelectionHandler.class);
    }

    public TransportSelectionHandler(InternalLogProvider logging) {
        this(false, logging);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.connection = Connection.getConnection(ctx.channel());
        this.connector = (AbstractNettyConnector)this.connection.connector();
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        if (this.detectSsl(in)) {
            if (this.isEncrypted) {
                this.log.error("Fatal error: multiple levels of SSL encryption detected. Terminating connection: %s", new Object[]{ctx.channel()});
                ctx.close();
                return;
            }
            this.enableSsl(ctx);
        } else if (TransportSelectionHandler.isHttp(in)) {
            this.switchToWebsocket(ctx);
        } else if (TransportSelectionHandler.isBoltPreamble(in)) {
            this.switchToSocket(ctx);
        } else {
            in.clear();
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            if (Exceptions.contains((Throwable)cause, e -> e.getMessage().contains("Connection reset by peer"))) {
                this.log.warn("Fatal error occurred when initialising pipeline, remote peer unexpectedly closed connection: %s", new Object[]{ctx.channel()});
            } else {
                this.log.error("Fatal error occurred when initialising pipeline: " + String.valueOf(ctx.channel()), cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    private static boolean isBoltPreamble(ByteBuf in) {
        return in.getInt(0) == 1616949271;
    }

    private boolean detectSsl(ByteBuf buf) {
        return ((AbstractNettyConnector.NettyConfiguration)this.connector.configuration()).sslContext() != null && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private static boolean isHttp(ByteBuf buf) {
        for (int i = 0; i < WEBSOCKET_MAGIC.length(); ++i) {
            if (buf.getUnsignedByte(buf.readerIndex() + i) == WEBSOCKET_MAGIC.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().allocateHeap(SSL_HANDLER_SHALLOW_SIZE);
        AbstractNettyConnector.NettyConfiguration config = (AbstractNettyConnector.NettyConfiguration)this.connector.configuration();
        SslContext sslContext = config.sslContext();
        SslHandler handler = sslContext.newHandler(ctx.alloc());
        handler.handshakeFuture().addListener((GenericFutureListener)new TransportSecuritySelectionFutureListener(ctx.channel(), this.connection, this.logging, (Log)this.log));
        ctx.pipeline().addLast(new ChannelHandler[]{handler}).remove((ChannelHandler)this);
    }

    private void switchToSocket(ChannelHandlerContext ctx) {
        if (((AbstractNettyConnector.NettyConfiguration)this.connector.configuration()).requiresEncryption() && !this.isEncrypted) {
            throw new SecurityException("An unencrypted connection attempt was made where encryption is required.");
        }
        this.switchToHandshake(ctx);
    }

    private void switchToWebsocket(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        this.connection.memoryTracker().allocateHeap(HTTP_SERVER_CODEC_SHALLOW_SIZE + HTTP_OBJECT_AGGREGATOR_SHALLOW_SIZE + DiscoveryResponseHandler.SHALLOW_SIZE + WEB_SOCKET_SERVER_PROTOCOL_HANDLER_SHALLOW_SIZE + WEB_SOCKET_FRAME_AGGREGATOR_SHALLOW_SIZE + WebSocketFramePackingEncoder.SHALLOW_SIZE + WebSocketFrameUnpackingDecoder.SHALLOW_SIZE);
        p.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(65536), new DiscoveryResponseHandler(this.connector.authConfigProvider()), new WebSocketServerProtocolHandler("/", null, false, 65536), new WebSocketFrameAggregator(65536), new WebSocketFramePackingEncoder(), new WebSocketFrameUnpackingDecoder()});
        this.switchToHandshake(ctx);
    }

    private void switchToHandshake(ChannelHandlerContext ctx) {
        AbstractNettyConnector.NettyConfiguration config = (AbstractNettyConnector.NettyConfiguration)this.connector.configuration();
        if (config.enableProtocolLogging() && config.protocolLoggingMode().isLoggingRawTraffic()) {
            this.connection.memoryTracker().allocateHeap(ProtocolLoggingHandler.SHALLOW_SIZE);
            ctx.pipeline().addLast("rawProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        this.connection.memoryTracker().allocateHeap(ProtocolNegotiationResponseEncoder.SHALLOW_SIZE + ProtocolNegotiationRequestDecoder.SHALLOW_SIZE + LegacyProtocolHandshakeHandler.SHALLOW_SIZE);
        ctx.pipeline().addLast("protocolNegotiationRequestEncoder", (ChannelHandler)new ProtocolNegotiationResponseEncoder()).addLast("protocolNegotiationRequestDecoder", (ChannelHandler)new ProtocolNegotiationRequestDecoder());
        if (config.enableProtocolLogging() && config.protocolLoggingMode().isLoggingDecodedTraffic()) {
            this.connection.memoryTracker().allocateHeap(ProtocolLoggingHandler.SHALLOW_SIZE);
            ctx.pipeline().addLast("decodedProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("protocolHandshakeHandler", (ChannelHandler)new LegacyProtocolHandshakeHandler(this.logging));
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private static class TransportSecuritySelectionFutureListener
    implements GenericFutureListener<Future<? super Channel>> {
        private final Channel channel;
        private final Connection connection;
        private final InternalLogProvider logging;
        private final Log log;

        public TransportSecuritySelectionFutureListener(Channel channel, Connection connection, InternalLogProvider logging, Log log) {
            this.channel = channel;
            this.connection = connection;
            this.logging = logging;
            this.log = log;
        }

        public void operationComplete(Future<? super Channel> f) throws Exception {
            if (!f.isSuccess()) {
                Throwable cause = f.cause();
                String message = "Unknown Error";
                if (cause != null) {
                    message = cause.getMessage();
                }
                this.log.debug("[%s] TLS handshake has failed: %s", new Object[]{this.channel.remoteAddress(), message});
                this.channel.close();
                return;
            }
            this.connection.memoryTracker().allocateHeap(SHALLOW_SIZE);
            this.channel.pipeline().addLast(new ChannelHandler[]{new TransportSelectionHandler(true, this.logging)});
        }
    }
}

