/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.authentication;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.authentication.AuthenticationMessage;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public final class AppendAdvertisedAddressOnStateTransition
extends AbstractStateTransition<AuthenticationMessage> {
    private static final AppendAdvertisedAddressOnStateTransition INSTANCE = new AppendAdvertisedAddressOnStateTransition();
    private static final String ADVERTISED_ADDRESS_KEY = "advertised_address";

    private AppendAdvertisedAddressOnStateTransition() {
        super(AuthenticationMessage.class);
    }

    public static AppendAdvertisedAddressOnStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference process(Context ctx, AuthenticationMessage message, ResponseHandler handler) throws StateMachineException {
        SocketAddress advertisedAddress = ctx.connection().connector().configuration().advertisedAddress();
        if (advertisedAddress != null) {
            String address = advertisedAddress.toString();
            if (advertisedAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)advertisedAddress;
                address = String.format("%s:%d", inetAddress.getHostName(), inetAddress.getPort());
            }
            handler.onMetadata(ADVERTISED_ADDRESS_KEY, (AnyValue)Values.stringValue((String)address));
        }
        return null;
    }
}

