/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.LocalDateTimeValue;

public final class LocalDateTimeReader<CTX>
implements StructReader<CTX, LocalDateTimeValue> {
    private static final LocalDateTimeReader<?> INSTANCE = new LocalDateTimeReader();

    private LocalDateTimeReader() {
    }

    public static <CTX> LocalDateTimeReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.LOCAL_DATE_TIME.getTag();
    }

    @Override
    public LocalDateTimeValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 2L) {
            throw IllegalStructSizeException.illegalStructSize(2L, header.length());
        }
        long epochSecond = buffer.readInt();
        long nanos = buffer.readInt();
        return LocalDateTimeValue.localDateTime((long)epochSecond, (long)nanos);
    }
}

