/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.graphdb.TransactionTerminatedHelper;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;

public class MutableConnectionState {
    private boolean responded;
    private Error pendingError;
    private boolean pendingIgnore;
    private ResponseHandler responseHandler;
    private Status pendingTerminationNotice;

    public void onMetadata(String key, AnyValue value) {
        if (this.responseHandler != null) {
            this.responseHandler.onMetadata(key, value);
        }
    }

    public void markIgnored() {
        this.pendingIgnore = true;
    }

    public void markFailed(Error error) {
        this.pendingError = error;
    }

    public Error getPendingError() {
        return this.pendingError;
    }

    public boolean hasPendingIgnore() {
        return this.pendingIgnore;
    }

    public void resetPendingFailedAndIgnored() {
        this.pendingError = null;
        this.pendingIgnore = false;
        this.pendingTerminationNotice = null;
    }

    public boolean canProcessMessage() {
        return this.pendingError == null && !this.pendingIgnore;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public void setPendingTerminationNotice(Status terminationNotice) {
        this.pendingTerminationNotice = terminationNotice;
    }

    public void ensureNoPendingTerminationNotice() {
        if (this.pendingTerminationNotice != null) {
            Status status = this.pendingTerminationNotice;
            this.pendingTerminationNotice = null;
            throw TransactionTerminatedHelper.transactionTerminated((Status)status);
        }
    }
}

