/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.error.state.IllegalTransitionException;
import org.neo4j.bolt.fsm.state.AbstractState;
import org.neo4j.bolt.fsm.state.HandlerRegistry;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.StateTransition;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

final class MultiTransitionState
extends AbstractState {
    private final HandlerRegistry<RequestMessage, StateTransition<?>> transitions;

    MultiTransitionState(StateReference reference, HandlerRegistry<RequestMessage, StateTransition<?>> transitions) {
        super(reference);
        this.transitions = transitions;
    }

    @Override
    public State.Factory builderOf() {
        State.Factory factory = State.builder(this.reference());
        this.transitions.forEach(factory::withTransition);
        return factory;
    }

    @Override
    public StateReference process(Context ctx, RequestMessage message, ResponseHandler handler) throws StateMachineException {
        StateTransition<?> transition = this.transitions.find(message.getClass());
        if (transition == null) {
            throw IllegalTransitionException.illegalTransition(this, message);
        }
        return transition.process(ctx, message, handler);
    }
}

