/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.request.connection;

import java.util.List;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.message.request.ImpersonationRequestMessage;
import org.neo4j.values.virtual.MapValue;

public final class RouteMessage
implements ImpersonationRequestMessage {
    public static final byte SIGNATURE = 102;
    private final MapValue requestContext;
    private final List<String> bookmarks;
    private final String databaseName;
    private final String impersonatedUser;

    public RouteMessage(MapValue requestContext, List<String> bookmarks, String databaseName, String impersonatedUser) {
        this.requestContext = requestContext;
        this.bookmarks = bookmarks;
        this.databaseName = databaseName;
        this.impersonatedUser = impersonatedUser;
    }

    @Override
    public String impersonatedUser() {
        return this.impersonatedUser;
    }

    public MapValue getRequestContext() {
        return this.requestContext;
    }

    public List<String> getBookmarks() {
        return this.bookmarks;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteMessage that = (RouteMessage)o;
        return Objects.equals(this.requestContext, that.requestContext) && Objects.equals(this.bookmarks, that.bookmarks) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.impersonatedUser, that.impersonatedUser);
    }

    public int hashCode() {
        return Objects.hash(this.requestContext, this.bookmarks, this.databaseName, this.impersonatedUser);
    }

    public String toString() {
        return "RouteMessage{requestContext=" + String.valueOf(this.requestContext) + ", bookmarks=" + String.valueOf(this.bookmarks) + ", databaseName='" + this.databaseName + "', impersonatedUser='" + this.impersonatedUser + "'}";
    }
}

