/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.response;

import java.util.List;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.values.virtual.MapValue;

public abstract class AbstractMetadataAwareResponseHandler
implements ResponseHandler {
    protected final MetadataHandler metadataHandler;

    public AbstractMetadataAwareResponseHandler(MetadataHandler metadataHandler) {
        this.metadataHandler = metadataHandler;
    }

    @Override
    public void onStatementPrepared(TransactionType transactionType, long statementId, long timeSpentPreparingResults, List<String> fieldNames) {
        if (transactionType != TransactionType.IMPLICIT) {
            this.metadataHandler.onStatementId(this, statementId);
        }
        this.metadataHandler.onTimeSpentPreparingResults(this, timeSpentPreparingResults);
        this.metadataHandler.onFieldNames(this, fieldNames);
    }

    @Override
    public void onTransactionDatabase(String database) {
        this.metadataHandler.onTransactionDatabase(this, database);
    }

    @Override
    public void onStreamingMetadata(long timeSpentStreaming, QueryExecutionType executionType, DatabaseReference database, QueryStatistics statistics, Iterable<Notification> notifications, Iterable<GqlStatusObject> statuses) {
        this.metadataHandler.onTimeSpentStreaming(this, timeSpentStreaming);
        this.metadataHandler.onExecutionType(this, executionType);
        this.metadataHandler.onDatabase(this, database);
        this.metadataHandler.onQueryStatistics(this, statistics);
        this.metadataHandler.onNotifications(this, notifications, statuses);
    }

    @Override
    public void onStreamingExecutionPlan(ExecutionPlanDescription plan) {
        this.metadataHandler.onExecutionPlan(this, plan);
    }

    @Override
    public void onCompleteStreaming(boolean hasRemaining) {
        this.metadataHandler.onResultsRemaining(this, hasRemaining);
    }

    @Override
    public void onRoutingTable(String databaseName, MapValue routingTable) {
        this.metadataHandler.onRoutingTable(this, databaseName, routingTable);
    }

    @Override
    public void onBookmark(String encodedBookmark) {
        this.metadataHandler.onBookmark(this, encodedBookmark);
    }
}

