/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.accounting.error;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.bolt.protocol.common.connector.accounting.error.TimeConstrainedCounter;

final class CircuitBreaker {
    private final long threshold;
    private final long resetMillis;
    private final Listener listener;
    private final Clock clock;
    private final TimeConstrainedCounter counter;
    private final AtomicReference<Long> tripped = new AtomicReference<Object>(null);

    CircuitBreaker(long threshold, long windowMillis, long resetMillis, Listener listener, Clock clock) {
        this.threshold = threshold;
        this.resetMillis = resetMillis;
        this.listener = listener;
        this.clock = clock;
        this.counter = new TimeConstrainedCounter(windowMillis, clock);
    }

    public void increment() {
        long now = this.clock.millis();
        long newValue = this.counter.incrementAndGet();
        if (newValue > this.threshold) {
            if (this.tripped.compareAndSet(null, now)) {
                this.listener.onTripped();
            } else {
                this.listener.onContinue();
            }
        } else {
            Long trippedAt = this.tripped.get();
            if (trippedAt != null && now - trippedAt >= this.resetMillis && this.tripped.compareAndSet(trippedAt, null)) {
                this.listener.onReset();
            } else {
                this.listener.onContinue();
            }
        }
    }

    static interface Listener {
        public void onTripped();

        public void onContinue();

        public void onReset();
    }
}

