/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.util.concurrent.Futures;

public class ConnectionRegistry {
    private final String connectorId;
    private final NetworkConnectionTracker connectionTracker;
    private final InternalLog log;
    private final Deque<Connection> connections = new ConcurrentLinkedDeque<Connection>();

    public ConnectionRegistry(String connectorId, NetworkConnectionTracker connectionTracker, InternalLogProvider logging) {
        this.connectorId = connectorId;
        this.connectionTracker = connectionTracker;
        this.log = logging.getLog(ConnectionRegistry.class);
    }

    public String allocateId() {
        return this.connectionTracker.newConnectionId(this.connectorId);
    }

    public void register(Connection connection) {
        this.connections.add(connection);
        if (this.connectionTracker != null) {
            this.connectionTracker.add((TrackedNetworkConnection)connection);
        }
        this.log.debug("[%s] Registered connection", new Object[]{connection.id()});
    }

    public void unregister(Connection connection) {
        this.connections.remove(connection);
        if (this.connectionTracker != null) {
            this.connectionTracker.remove((TrackedNetworkConnection)connection);
        }
        this.log.debug("[%s] Removed connection", new Object[]{connection.id()});
    }

    public void stopIdling(Duration shutdownDeadline) {
        Iterator<Connection> it = this.connections.iterator();
        this.log.info("Stopping remaining idle connections for connector %s", new Object[]{this.connectorId});
        int n = 0;
        ArrayList futures = new ArrayList();
        while (it.hasNext()) {
            Connection connection = it.next();
            if (!connection.isIdling()) continue;
            this.log.debug("[%s] Stopping idle connection", new Object[]{connection.id()});
            connection.close();
            futures.add(connection.closeFuture());
            it.remove();
            if (this.connectionTracker != null) {
                this.connectionTracker.remove((TrackedNetworkConnection)connection);
            }
            ++n;
            this.log.debug("[%s] Stopped idle connection", new Object[]{connection.id()});
        }
        Future combined = Futures.combine(futures);
        try {
            if (!shutdownDeadline.isZero()) {
                combined.get(shutdownDeadline.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                combined.get();
            }
        }
        catch (TimeoutException ex) {
            this.log.warn("Idle connections have failed to terminate within acceptable duration (" + String.valueOf(shutdownDeadline) + ")", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            this.log.warn("Interrupted while awaiting clean shutdown of idle connections", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            this.log.warn("Clean shutdown of idle connections has failed", (Throwable)ex);
        }
        this.log.info("Stopped %d idling connections for connector %s", new Object[]{n, this.connectorId});
    }

    public void stopAll(Duration shutdownDeadline) {
        this.log.info("Stopping %d connections for connector %s", new Object[]{this.connections.size(), this.connectorId});
        List<Future> futures = this.connections.stream().map(connection -> {
            this.log.debug("[%s] Requesting connection closure", new Object[]{connection.id()});
            connection.close();
            if (this.connectionTracker != null) {
                this.connectionTracker.remove((TrackedNetworkConnection)connection);
            }
            return connection.closeFuture();
        }).toList();
        Future combined = Futures.combine(futures);
        try {
            if (!shutdownDeadline.isZero()) {
                combined.get(shutdownDeadline.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                combined.get();
            }
        }
        catch (TimeoutException ex) {
            this.log.error("Connection have failed to terminate within acceptable duration (" + String.valueOf(shutdownDeadline) + ")", (Throwable)ex);
            return;
        }
        catch (InterruptedException ex) {
            this.log.warn("Interrupted while awaiting clean shutdown of connections", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            this.log.warn("Clean shutdown of connections has failed", (Throwable)ex);
        }
        this.connections.clear();
        this.log.info("Stopped all remaining connections for connector %s", new Object[]{this.connectorId});
    }
}

