/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.io;

import java.util.List;
import org.neo4j.packstream.io.LengthPrefix;
import org.neo4j.packstream.io.Type;

public enum TypeMarker {
    RESERVED(0, Type.RESERVED, LengthPrefix.NONE),
    TINY_INT(0, Type.INT, LengthPrefix.NONE),
    TINY_STRING(128, Type.STRING, LengthPrefix.NIBBLE),
    TINY_LIST(144, Type.LIST, LengthPrefix.NIBBLE),
    TINY_MAP(160, Type.MAP, LengthPrefix.NIBBLE),
    TINY_STRUCT(176, Type.STRUCT, LengthPrefix.NIBBLE),
    NULL(192, Type.NONE, LengthPrefix.NONE),
    FALSE(194, Type.BOOLEAN, LengthPrefix.NONE),
    TRUE(195, Type.BOOLEAN, LengthPrefix.NONE),
    INT8(200, Type.INT, LengthPrefix.NONE),
    INT16(201, Type.INT, LengthPrefix.NONE),
    INT32(202, Type.INT, LengthPrefix.NONE),
    INT64(203, Type.INT, LengthPrefix.NONE),
    FLOAT64(193, Type.FLOAT, LengthPrefix.NONE),
    BYTES8(204, Type.BYTES, LengthPrefix.UINT8),
    BYTES16(205, Type.BYTES, LengthPrefix.UINT16),
    BYTES32(206, Type.BYTES, LengthPrefix.UINT32),
    STRING8(208, Type.STRING, LengthPrefix.UINT8),
    STRING16(209, Type.STRING, LengthPrefix.UINT16),
    STRING32(210, Type.STRING, LengthPrefix.UINT32),
    LIST8(212, Type.LIST, LengthPrefix.UINT8),
    LIST16(213, Type.LIST, LengthPrefix.UINT16),
    LIST32(214, Type.LIST, LengthPrefix.UINT32),
    MAP8(216, Type.MAP, LengthPrefix.UINT8),
    MAP16(217, Type.MAP, LengthPrefix.UINT16),
    MAP32(218, Type.MAP, LengthPrefix.UINT32),
    STRUCT8(220, Type.STRUCT, LengthPrefix.UINT8),
    STRUCT16(221, Type.STRUCT, LengthPrefix.UINT16);

    public static final short MARKER_MIN = 128;
    public static final short MARKER_MAX = 239;
    public static final short VALID_MARKER_COUNT = 111;
    private static final TypeMarker[] lookupTable;
    public static final List<TypeMarker> BOOLEAN_VALUES;
    public static final List<TypeMarker> BYTES_TYPES;
    public static final List<TypeMarker> INT_TYPES;
    public static final List<TypeMarker> LIST_TYPES;
    public static final List<TypeMarker> MAP_TYPES;
    public static final List<TypeMarker> STRING_TYPES;
    public static final List<TypeMarker> STRUCT_TYPES;
    private final short value;
    private final Type type;
    private final LengthPrefix lengthPrefix;

    private TypeMarker(int value, Type type, LengthPrefix lengthPrefix) {
        this.value = (short)value;
        this.type = type;
        this.lengthPrefix = lengthPrefix;
    }

    public static TypeMarker byEncoded(short marker) {
        if (marker < 128 || marker > 239) {
            return TINY_INT;
        }
        int offset = marker - 128;
        TypeMarker type = lookupTable[offset];
        if (type == null) {
            return RESERVED;
        }
        return type;
    }

    public static int decodeLengthNibble(short marker) {
        return marker & 0xF;
    }

    public static int encodeLengthNibble(TypeMarker marker, int length) {
        return marker.value ^ length & 0xFF;
    }

    public static void requireEncodableLength(TypeMarker marker, long length) {
        if (!marker.canEncodeLength(length)) {
            throw new IllegalArgumentException("Payload of " + length + " exceeds maximum of " + marker.lengthPrefix.getMaxValue());
        }
    }

    public short getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public LengthPrefix getLengthPrefix() {
        return this.lengthPrefix;
    }

    public boolean canEncodeLength(long length) {
        if (!this.hasLengthPrefix()) {
            return false;
        }
        return this.lengthPrefix.canEncode(length);
    }

    public boolean hasLengthPrefix() {
        return this.lengthPrefix != LengthPrefix.NONE;
    }

    public boolean isNibbleMarker() {
        return this.lengthPrefix == LengthPrefix.NIBBLE;
    }

    static {
        lookupTable = new TypeMarker[111];
        BOOLEAN_VALUES = List.of(FALSE, TRUE);
        BYTES_TYPES = List.of(BYTES8, BYTES16, BYTES32);
        INT_TYPES = List.of(TINY_INT, INT8, INT16, INT32, INT64);
        LIST_TYPES = List.of(TINY_LIST, LIST8, LIST16, LIST32);
        MAP_TYPES = List.of(TINY_MAP, MAP8, MAP16, MAP32);
        STRING_TYPES = List.of(TINY_STRING, STRING8, STRING16, STRING32);
        STRUCT_TYPES = List.of(TINY_STRUCT, STRUCT8, STRUCT16);
        for (TypeMarker marker : TypeMarker.values()) {
            if (marker == RESERVED || marker == TINY_INT) continue;
            TypeMarker.lookupTable[marker.value - 128] = marker;
            if (!marker.isNibbleMarker()) continue;
            for (int i = 1; i < 16; ++i) {
                TypeMarker.lookupTable[(marker.value ^ i) - 128] = marker;
            }
        }
    }
}

