/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.txtracking;

import java.time.Duration;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.bolt.txtracking.TransactionIdTrackerException;
import org.neo4j.bolt.txtracking.TransactionIdTrackerMonitor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Stopwatch;
import org.neo4j.time.SystemNanoClock;

public class TransactionIdTracker {
    private final DatabaseManagementService managementService;
    private final TransactionIdTrackerMonitor monitor;
    private final SystemNanoClock clock;
    private final Log log;

    public TransactionIdTracker(DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock, LogProvider logProvider) {
        this.managementService = managementService;
        this.monitor = (TransactionIdTrackerMonitor)monitors.newMonitor(TransactionIdTrackerMonitor.class, new String[0]);
        this.clock = clock;
        this.log = logProvider.getLog(this.getClass());
    }

    public long newestTransactionId(NamedDatabaseId namedDatabaseId) {
        AbstractDatabase db = this.database(namedDatabaseId);
        try {
            return TransactionIdTracker.transactionIdStore(db).getLastCommittedTransactionId();
        }
        catch (RuntimeException e) {
            throw TransactionIdTracker.databaseUnavailable(db, e);
        }
    }

    public void awaitUpToDate(NamedDatabaseId namedDatabaseId, long oldestAcceptableTxId, Duration timeout) {
        AbstractDatabase db = this.database(namedDatabaseId);
        if (oldestAcceptableTxId <= 1L) {
            return;
        }
        long lastTransactionId = -1L;
        try {
            Stopwatch startTime = this.clock.startStopWatch();
            boolean waited = false;
            do {
                if (TransactionIdTracker.isNotAvailable(db)) {
                    throw TransactionIdTracker.databaseUnavailable(db);
                }
                lastTransactionId = TransactionIdTracker.currentTransactionId(db);
                if (oldestAcceptableTxId <= lastTransactionId) {
                    this.log.debug("Done waiting for bookmark on database '%s' after %s (awaited:%s, reached:%s)", new Object[]{namedDatabaseId, waited ? startTime.elapsed() : Duration.ZERO, oldestAcceptableTxId, lastTransactionId});
                    return;
                }
                this.waitWhenNotUpToDate();
                waited = true;
            } while (!startTime.hasTimedOut(timeout));
            throw TransactionIdTracker.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId);
        }
        catch (RuntimeException e) {
            if (TransactionIdTracker.isNotAvailable(db)) {
                throw TransactionIdTracker.databaseUnavailable(db, e);
            }
            throw TransactionIdTrackerException.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId, e);
        }
    }

    private void waitWhenNotUpToDate() {
        this.monitor.onWaitWhenNotUpToDate();
        LockSupport.parkNanos(100L);
    }

    private static long currentTransactionId(AbstractDatabase db) {
        return TransactionIdTracker.transactionIdStore(db).getLastClosedTransactionId();
    }

    private static TransactionIdStore transactionIdStore(AbstractDatabase db) {
        return (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private AbstractDatabase database(NamedDatabaseId namedDatabaseId) {
        try {
            GraphDatabaseAPI dbApi = (GraphDatabaseAPI)this.managementService.database(namedDatabaseId.name());
            AbstractDatabase db = (AbstractDatabase)dbApi.getDependencyResolver().resolveDependency(AbstractDatabase.class);
            if (TransactionIdTracker.isNotAvailable(db)) {
                throw TransactionIdTracker.databaseUnavailable(db);
            }
            return db;
        }
        catch (DatabaseNotFoundException e) {
            throw TransactionIdTracker.databaseNotFound(namedDatabaseId);
        }
    }

    private static boolean isNotAvailable(AbstractDatabase db) {
        return !db.getDatabaseAvailabilityGuard().isAvailable();
    }

    private static TransactionIdTrackerException databaseNotFound(NamedDatabaseId namedDatabaseId) {
        return new TransactionIdTrackerException((Status)Status.Database.DatabaseNotFound, "Database '" + namedDatabaseId.name() + "' does not exist");
    }

    private static TransactionIdTrackerException databaseUnavailable(AbstractDatabase db) {
        return TransactionIdTracker.databaseUnavailable(db, null);
    }

    private static TransactionIdTrackerException databaseUnavailable(AbstractDatabase db, Throwable cause) {
        return TransactionIdTrackerException.databaseUnavailable(db.getNamedDatabaseId().name(), cause);
    }

    private static TransactionIdTrackerException unreachableDatabaseVersion(AbstractDatabase db, long lastTransactionId, long oldestAcceptableTxId) {
        return TransactionIdTrackerException.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId, null);
    }
}

