/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.event.CopyOnWriteEventPublisher;
import org.neo4j.bolt.event.EventPublisher;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionCloseException;
import org.neo4j.bolt.tx.error.TransactionCompletionException;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.error.statement.StatementException;
import org.neo4j.bolt.tx.error.statement.StatementExecutionException;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.bolt.tx.statement.StatementImpl;
import org.neo4j.bolt.tx.statement.StatementQuerySubscriber;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.values.virtual.MapValue;

public class TransactionImpl
implements Transaction {
    private final String id;
    private final TransactionType type;
    private final DatabaseReference database;
    private final Clock clock;
    private final BoltTransaction transaction;
    private final AtomicReference<State> state = new AtomicReference<State>(State.OPEN);
    private final AtomicBoolean interrupted = new AtomicBoolean();
    private final EventPublisher<Transaction.Listener> eventPublisher = new CopyOnWriteEventPublisher<Transaction.Listener>();
    private final Lock statementLock = new ReentrantLock();
    private final AtomicLong nextStatementId = new AtomicLong();
    private volatile long latestStatementId;
    private final StatementCleanupListener statementListener = new StatementCleanupListener();
    private final Map<Long, Statement> statementMap = new HashMap<Long, Statement>();
    private volatile boolean failed;

    public TransactionImpl(String id, TransactionType type, DatabaseReference database, Clock clock, BoltTransaction transaction) {
        this.id = id;
        this.type = type;
        this.database = database;
        this.clock = clock;
        this.transaction = transaction;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public TransactionType type() {
        return this.type;
    }

    @Override
    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    @Override
    public boolean isValid() {
        return this.state.get() != State.CLOSED;
    }

    @Override
    public long latestStatementId() {
        return this.latestStatementId;
    }

    @Override
    public boolean hasOpenStatement() {
        return !this.statementMap.isEmpty();
    }

    @Override
    public boolean hasFailed() {
        return this.failed;
    }

    public void markFailed() {
        this.failed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement run(String statement, MapValue params) throws StatementException {
        BoltQueryExecution query;
        long statementId;
        this.latestStatementId = statementId = this.nextStatementId.getAndIncrement();
        StatementQuerySubscriberIml subscriber = new StatementQuerySubscriberIml();
        try {
            query = this.transaction.executeQuery(statement, params, true, subscriber);
            subscriber.assertSuccess();
        }
        catch (Exception ex) {
            this.markFailed();
            throw new StatementExecutionException(ex);
        }
        StatementImpl handle = new StatementImpl(statementId, this.database, this.clock, query, subscriber);
        handle.registerListener(this.statementListener);
        this.statementLock.lock();
        try {
            this.statementMap.put(statementId, handle);
        }
        finally {
            this.statementLock.unlock();
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Statement> getStatement(long id) {
        this.statementLock.lock();
        try {
            Optional<Statement> optional = Optional.ofNullable(this.statementMap.get(id));
            return optional;
        }
        finally {
            this.statementLock.unlock();
        }
    }

    @Override
    public String commit() throws TransactionException {
        State updatedValue = this.state.compareAndExchange(State.OPEN, State.COMMITTED);
        if (updatedValue != State.OPEN) {
            throw new TransactionCompletionException("Transaction \"" + this.id + "\" has already terminated with state " + String.valueOf((Object)updatedValue));
        }
        try {
            this.transaction.commit();
        }
        catch (Exception ex) {
            throw new TransactionCompletionException("Failed to commit transaction \"" + this.id + "\"", ex);
        }
        String bookmark = this.transaction.getBookmark();
        this.eventPublisher.dispatch(l -> l.onCommit(this, bookmark));
        return bookmark;
    }

    @Override
    public void rollback() throws TransactionException {
        State updatedValue = this.state.compareAndExchange(State.OPEN, State.ROLLED_BACK);
        if (updatedValue != State.OPEN) {
            throw new TransactionCompletionException("Transaction \"" + this.id + "\" has already terminated with state " + String.valueOf((Object)updatedValue));
        }
        this.statementLock.lock();
        try {
            this.statementMap.values().forEach(statement -> {
                try {
                    statement.terminate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        finally {
            this.statementLock.unlock();
        }
        try {
            this.transaction.rollback();
        }
        catch (Exception ex) {
            throw new TransactionCompletionException("Failed to rollback transaction \"" + this.id + "\"", ex);
        }
        this.eventPublisher.dispatch(l -> l.onRollback(this));
    }

    @Override
    public void interrupt() {
        if (!this.interrupted.compareAndSet(false, true)) {
            return;
        }
        this.transaction.markForTermination((Status)Status.Transaction.Terminated);
    }

    @Override
    public boolean validate() {
        Optional<Status> reason = this.transaction.getReasonIfTerminated().filter(status -> status.code().classification().rollbackTransaction());
        return reason.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws TransactionCloseException {
        State previousState;
        do {
            if ((previousState = this.state.get()) != State.CLOSED) continue;
            return;
        } while (!this.state.compareAndSet(previousState, State.CLOSED));
        this.statementLock.lock();
        try {
            Set<Statement> statements = Set.copyOf(this.statementMap.values());
            for (Statement statement : statements) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.statementLock.unlock();
        }
        if (previousState == State.OPEN) {
            try {
                this.transaction.rollback();
            }
            catch (TransactionFailureException statements) {
                // empty catch block
            }
        }
        try {
            this.transaction.close();
        }
        catch (TransactionFailureException ex) {
            throw new TransactionCloseException("Failed to close transaction \"" + this.id + "\"", ex);
        }
        this.eventPublisher.dispatchSafe((ThrowingConsumer<Transaction.Listener, Exception>)((ThrowingConsumer)l -> l.onClose(this)));
    }

    @Override
    public void registerListener(Transaction.Listener listener) {
        this.eventPublisher.registerListener(listener);
    }

    @Override
    public void removeListener(Transaction.Listener listener) {
        this.eventPublisher.removeListener(listener);
    }

    private static enum State {
        OPEN,
        COMMITTED,
        ROLLED_BACK,
        CLOSED;

    }

    private class StatementCleanupListener
    implements Statement.Listener {
        private StatementCleanupListener() {
        }

        @Override
        public void onClosed(Statement statement) {
            TransactionImpl.this.statementLock.lock();
            try {
                TransactionImpl.this.statementMap.remove(statement.id());
            }
            finally {
                TransactionImpl.this.statementLock.unlock();
            }
        }
    }

    private class StatementQuerySubscriberIml
    extends StatementQuerySubscriber {
        private StatementQuerySubscriberIml() {
        }

        @Override
        public void onError(Throwable throwable) throws Exception {
            TransactionImpl.this.markFailed();
            super.onError(throwable);
        }
    }
}

