/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.throttle;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.transport.TransportThrottleException;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class ChannelWriteThrottleHandler
extends ChannelDuplexHandler {
    private final long maxWriteLockMillis;
    private final InternalLog log;
    private Future<?> reaperFuture;

    public ChannelWriteThrottleHandler(long maxWriteLockMillis, InternalLogProvider logging) {
        this.maxWriteLockMillis = maxWriteLockMillis;
        this.log = logging.getLog(ChannelWriteThrottleHandler.class);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Future<?> reaperFuture = this.reaperFuture;
        if (reaperFuture != null) {
            reaperFuture.cancel(false);
            this.reaperFuture = null;
        }
        super.channelInactive(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            if (this.reaperFuture != null) {
                this.reaperFuture.cancel(false);
                this.reaperFuture = null;
            }
        } else if (this.reaperFuture == null) {
            this.reaperFuture = ctx.executor().schedule(() -> {
                TransportThrottleException ex = new TransportThrottleException(this.maxWriteLockMillis);
                this.log.error("Fatal error occurred when handling a client connection", (Throwable)ex);
                ctx.close();
            }, this.maxWriteLockMillis, TimeUnit.MILLISECONDS);
        }
        ctx.fireChannelWritabilityChanged();
    }
}

