/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.DurationValue;

public final class DurationReader<CTX>
implements StructReader<CTX, DurationValue> {
    private static final DurationReader<?> INSTANCE = new DurationReader();

    private DurationReader() {
    }

    public static <CTX> DurationReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.DURATION.getTag();
    }

    @Override
    public DurationValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 4L) {
            throw new IllegalStructSizeException(4L, header.length());
        }
        long months = buffer.readInt();
        long days = buffer.readInt();
        long seconds = buffer.readInt();
        long nanos = buffer.readInt();
        return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
    }
}

