/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.packstream.codec.transport.ChunkFrameDecoder;

public class ReadLimitConnectionListener
implements ConnectionListener {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadLimitConnectionListener.class);
    private final Connection connection;
    private final InternalLog log;
    private final long limit;

    public ReadLimitConnectionListener(Connection connection, InternalLogProvider logging, long limit) {
        this.connection = connection;
        this.log = logging.getLog(ReadLimitConnectionListener.class);
        this.limit = limit;
    }

    @Override
    public void onListenerRemoved() {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    @Override
    public void onLogon(LoginContext ctx) {
        this.log.debug("[%s] Removing read limit", new Object[]{this.connection.id()});
        try (MemoryTracker memoryTracker = this.connection.memoryTracker().getScopedMemoryTracker();){
            memoryTracker.allocateHeap(ChunkFrameDecoder.SHALLOW_SIZE);
            ChannelPipeline pipeline = this.connection.channel().pipeline();
            ChunkFrameDecoder oldDecoder = (ChunkFrameDecoder)pipeline.get(ChunkFrameDecoder.class);
            ChunkFrameDecoder newDecoder = oldDecoder.unlimited();
            pipeline.replace((ChannelHandler)oldDecoder, "chunkFrameDecoder", (ChannelHandler)newDecoder);
        }
    }

    @Override
    public void onLogoff() {
        this.log.debug("[%s] Re-adding read limit of [%o]", new Object[]{this.connection.id(), this.limit});
        try (MemoryTracker memoryTracker = this.connection.memoryTracker().getScopedMemoryTracker();){
            memoryTracker.allocateHeap(ChunkFrameDecoder.SHALLOW_SIZE);
            ChannelPipeline pipeline = this.connection.channel().pipeline();
            ChunkFrameDecoder oldDecoder = (ChunkFrameDecoder)pipeline.get(ChunkFrameDecoder.class);
            ChunkFrameDecoder newDecoder = oldDecoder.limit(this.limit);
            pipeline.replace((ChannelHandler)oldDecoder, "chunkFrameDecoder", (ChannelHandler)newDecoder);
        }
    }
}

