/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connector.ConnectionRegistry;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.TrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.listener.ConnectorListener;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;

public interface Connector<CFG extends Configuration>
extends Lifecycle {
    public String id();

    public SocketAddress address();

    public MemoryPool memoryPool();

    public Clock clock();

    public ConnectionRegistry connectionRegistry();

    public BoltProtocolRegistry protocolRegistry();

    public Set<ProtocolCapability> supportedCapabilities();

    public Authentication authentication();

    public AuthConfigProvider authConfigProvider();

    public DefaultDatabaseResolver defaultDatabaseResolver();

    public ConnectionHintRegistry connectionHintRegistry();

    public TransactionManager transactionManager();

    public BoltDriverMetricsMonitor driverMetricsMonitor();

    public RoutingService routingService();

    public ErrorAccountant errorAccountant();

    public TrafficAccountant trafficAccountant();

    public CFG configuration();

    public void registerListener(ConnectorListener var1);

    public void removeListener(ConnectorListener var1);

    public void notifyListeners(Consumer<ConnectorListener> var1);

    public Connection createConnection(Channel var1);

    default public void init() throws Exception {
    }

    default public void shutdown() throws Exception {
    }

    public static interface Configuration {
        public boolean enableProtocolCapture();

        public Path protocolCapturePath();

        public boolean enableProtocolLogging();

        public BoltConnectorInternalSettings.ProtocolLoggingMode protocolLoggingMode();

        public long maxAuthenticationInboundBytes();

        public int maxAuthenticationStructureElements();

        public int maxAuthenticationStructureDepth();

        public boolean enableOutboundBufferThrottle();

        public int outboundBufferThrottleLowWatermark();

        public int outboundBufferThrottleHighWatermark();

        public Duration outboundBufferMaxThrottleDuration();

        public int inboundBufferThrottleLowWatermark();

        public int inboundBufferThrottleHighWatermark();

        public int streamingBufferSize();

        public int streamingFlushThreshold();

        public Duration connectionShutdownDuration();

        public boolean enableTransactionThreadBinding();

        public Duration threadBindingTimeout();

        public SocketAddress advertisedAddress();
    }
}

