/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connection.hint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintProvider;
import org.neo4j.values.virtual.MapValueBuilder;

public final class ConnectionHintRegistry {
    private final List<ConnectionHintProvider> providers;

    private ConnectionHintRegistry(List<ConnectionHintProvider> providers) {
        this.providers = providers;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void applyTo(ProtocolVersion version, MapValueBuilder builder) {
        this.providers.stream().filter(it -> version.isAtLeast(it.supportedSince()) && version.isAtMost(it.supportedUntil())).filter(it -> it.isApplicable()).forEach(it -> it.append(builder));
    }

    public static final class Builder {
        private final List<ConnectionHintProvider> providers = new ArrayList<ConnectionHintProvider>();

        private Builder() {
        }

        public ConnectionHintRegistry build() {
            return new ConnectionHintRegistry(new ArrayList<ConnectionHintProvider>(this.providers));
        }

        public Builder withProvider(ConnectionHintProvider provider) {
            this.providers.add(provider);
            return this;
        }

        public Builder withProviders(ConnectionHintProvider ... providers) {
            this.providers.addAll(Arrays.asList(providers));
            return this;
        }
    }
}

