/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationRequest;
import org.neo4j.memory.HeapEstimator;

public class ProtocolNegotiationRequestDecoder
extends ByteToMessageDecoder {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ProtocolNegotiationRequestDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 20) {
            return;
        }
        int magicNumber = in.readInt();
        List<ProtocolVersion> proposedVersions = IntStream.range(0, 4).map(n -> in.readInt()).mapToObj(ProtocolVersion::new).filter(version -> !ProtocolVersion.INVALID.equals(version)).collect(Collectors.toList());
        out.add(new ProtocolNegotiationRequest(magicNumber, proposedVersions));
    }
}

