/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util.fst;

import java.io.IOException;
import org.neo4j.shaded.lucene9.store.RandomAccessInput;
import org.neo4j.shaded.lucene9.util.fst.FST;

final class ReverseRandomAccessReader
extends FST.BytesReader {
    private final RandomAccessInput in;
    private long pos;

    public ReverseRandomAccessReader(RandomAccessInput in) {
        this.in = in;
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte(this.pos--);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int i = offset;
        int end = offset + len;
        while (i < end) {
            b[i++] = this.in.readByte(this.pos--);
        }
    }

    @Override
    public void skipBytes(long count) {
        this.pos -= count;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = pos;
    }
}

