/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util.fst;

import java.io.IOException;
import org.neo4j.shaded.lucene9.store.DataInput;
import org.neo4j.shaded.lucene9.store.DataOutput;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;
import org.neo4j.shaded.lucene9.util.fst.FST;
import org.neo4j.shaded.lucene9.util.fst.FSTCompiler;
import org.neo4j.shaded.lucene9.util.fst.FSTReader;
import org.neo4j.shaded.lucene9.util.fst.ReadWriteDataOutput;
import org.neo4j.shaded.lucene9.util.fst.ReverseBytesReader;

public final class OnHeapFSTStore
implements FSTReader {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OnHeapFSTStore.class);
    private ReadWriteDataOutput dataOutput;
    private final byte[] bytesArray;

    public OnHeapFSTStore(int maxBlockBits, DataInput in, long numBytes) throws IOException {
        if (maxBlockBits < 1 || maxBlockBits > 30) {
            throw new IllegalArgumentException("maxBlockBits should be 1 .. 30; got " + maxBlockBits);
        }
        if (numBytes > (long)(1 << maxBlockBits)) {
            this.dataOutput = (ReadWriteDataOutput)FSTCompiler.getOnHeapReaderWriter(maxBlockBits);
            this.dataOutput.copyBytes(in, numBytes);
            this.dataOutput.freeze();
            this.bytesArray = null;
        } else {
            this.bytesArray = new byte[(int)numBytes];
            in.readBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }

    @Override
    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES_USED;
        size = this.bytesArray != null ? (size += (long)this.bytesArray.length) : (size += this.dataOutput.ramBytesUsed());
        return size;
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        if (this.bytesArray != null) {
            return new ReverseBytesReader(this.bytesArray);
        }
        return this.dataOutput.getReverseBytesReader();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.dataOutput != null) {
            this.dataOutput.writeTo(out);
        } else {
            assert (this.bytesArray != null);
            out.writeBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }
}

